/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;

class KafkaLogicalClusterMetadataTestUtils {
    static final String TOPIC = "_confluent-logical_cluster";
    static final String LKC_ID_CHARS = "1234567890abcdefghijklmnopqrstuvwxyz-";
    static final int LKC_ID_LENGTH = 9;

    KafkaLogicalClusterMetadataTestUtils() {
    }

    static ConsumerRecord<String, byte[]> createConsumerRecord(long seqId, KafkaLogicalClusterMetadata value) {
        return KafkaLogicalClusterMetadataTestUtils.createConsumerRecord(seqId, value, true);
    }

    static ConsumerRecord<String, byte[]> createConsumerRecord(long seqId, KafkaLogicalClusterMetadata value, boolean newSeqIdHeader) {
        return KafkaLogicalClusterMetadataTestUtils.createConsumerRecord(seqId, value.logicalClusterId(), value, newSeqIdHeader);
    }

    static ConsumerRecord<String, byte[]> createConsumerRecord(long seqId, String key, KafkaLogicalClusterMetadata value) {
        return KafkaLogicalClusterMetadataTestUtils.createConsumerRecord(seqId, key, value, true);
    }

    static ConsumerRecord<String, byte[]> createConsumerRecord(long seqId, String key, KafkaLogicalClusterMetadata value, boolean newSeqIdHeader) {
        RecordHeaders headers = KafkaTestUtils.createGoodSequenceIdRecordHeaders(seqId, newSeqIdHeader);
        byte[] serializedValue = KafkaLogicalClusterUtils.protoFromMetadata((KafkaLogicalClusterMetadata)value).toByteArray();
        return new ConsumerRecord(TOPIC, 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)key, (Object)serializedValue, (Headers)headers, Optional.empty());
    }

    static ConsumerRecord<String, byte[]> createEmptyConsumerRecord(long seqId, String key) {
        return KafkaLogicalClusterMetadataTestUtils.createEmptyConsumerRecord(seqId, key, true);
    }

    static ConsumerRecord<String, byte[]> createEmptyConsumerRecord(long seqId, String key, boolean newSeqIdHeader) {
        RecordHeaders headers = KafkaTestUtils.createGoodSequenceIdRecordHeaders(seqId, newSeqIdHeader);
        return new ConsumerRecord(TOPIC, 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)key, null, (Headers)headers, Optional.empty());
    }

    static String generateLkcId(Random random) {
        return random.ints(9L, 0, LKC_ID_CHARS.length()).collect(StringBuilder::new, (sb, i) -> sb.append(LKC_ID_CHARS.charAt(i)), StringBuilder::append).toString();
    }

    static KafkaLogicalClusterMetadata createLcm(String lkcId) {
        return new KafkaLogicalClusterMetadata(lkcId, "pkc-dontcare", lkcId, "my-account", "k8s-abc", "kafka", Long.valueOf(0x6400000L), Long.valueOf(512000L), Long.valueOf(1024000L), Long.valueOf(512000L), Long.valueOf(1024000L), Long.valueOf(1600L), KafkaLogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new KafkaLogicalClusterMetadata.LifecycleMetadata("lkc-tenant1", "pkc-xyz", new Date(), null), null, Integer.valueOf(12000), "some-org", "some-env", Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()), KafkaLogicalClusterUtils.ELASTIC_CKU_METADATA_DEFAULT, KafkaLogicalClusterUtils.CKU_COUNT, Boolean.valueOf(true));
    }

    static List<ConsumerRecord<String, byte[]>> generateRecords(int count) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        HashSet<String> lkcIds = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            String key;
            while (lkcIds.contains(key = KafkaLogicalClusterMetadataTestUtils.generateLkcId(random))) {
            }
            lkcIds.add(key);
        }
        return lkcIds.stream().map(id -> KafkaLogicalClusterMetadataTestUtils.createConsumerRecord(1L, id, KafkaLogicalClusterMetadataTestUtils.createLcm(id), true)).collect(Collectors.toList());
    }

    static Endpoint createEndpoint(String listenerName) {
        return new Endpoint(listenerName, SecurityProtocol.PLAINTEXT, "", 0);
    }
}

