/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.cluster;

import io.confluent.kafka.multitenant.integration.cluster.TestPlainLoginModule;
import io.confluent.kafka.multitenant.integration.cluster.UserMetadata;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramLoginModule;

public class LogicalClusterUser {
    public final UserMetadata userMetadata;
    public final String logicalClusterId;

    public LogicalClusterUser(UserMetadata userMetadata, String logicalClusterId) {
        this.userMetadata = userMetadata;
        this.logicalClusterId = logicalClusterId;
    }

    public String saslUserName() {
        return this.withPrefix(this.userMetadata.apiKey());
    }

    public String saslJaasConfig() {
        return String.format("%s required username=\"%s\" password=\"%s\";", ScramLoginModule.class.getName(), this.saslUserName(), this.userMetadata.apiSecret());
    }

    public String testPlainSaslJaasConfig() {
        return String.format("%s required username=\"%s\" password=\"%s\";", TestPlainLoginModule.class.getName(), this.saslUserName(), this.userMetadata.apiSecret());
    }

    public KafkaPrincipal prefixedKafkaPrincipal() {
        return new KafkaPrincipal("TenantUser", this.withPrefix(String.valueOf(this.userMetadata.userId())));
    }

    public KafkaPrincipal prefixedKafkaPrincipalWithResourceId() {
        return new KafkaPrincipal("TenantUser", this.withPrefix(String.valueOf(this.userMetadata.userResourceId())));
    }

    public KafkaPrincipal unprefixedKafkaPrincipal() {
        return new KafkaPrincipal("User", String.valueOf(this.userMetadata.userId()));
    }

    public KafkaPrincipal unprefixedKafkaPrincipalWithResourceId() {
        return new KafkaPrincipal("User", String.valueOf(this.userMetadata.userResourceId()));
    }

    public String tenantPrefix() {
        return this.logicalClusterId + "_";
    }

    public String withPrefix(String name) {
        return this.tenantPrefix() + name;
    }

    public String userResourceId() {
        return this.userMetadata.userResourceId();
    }

    public String toString() {
        return "LogicalClusterUser: " + this.saslUserName();
    }
}

