/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TestCluster {
    private final List<Broker> brokers;
    private final List<String> consecutiveBrokerRacks;
    private final Set<String> uniqueRacks;
    private final Set<Integer> brokerIds;
    private final List<String> consecutiveBrokerCells;
    private final Set<String> uniqueCells;
    private final Map<Integer, String> cellsByBrokerId;
    private final Map<String, Set<String>> racksByCellId;

    private TestCluster(List<Broker> brokers) {
        this.brokers = brokers;
        this.consecutiveBrokerRacks = new ArrayList<String>();
        this.consecutiveBrokerCells = new ArrayList<String>();
        this.brokerIds = new HashSet<Integer>();
        this.cellsByBrokerId = new HashMap<Integer, String>();
        this.racksByCellId = new HashMap<String, Set<String>>();
        for (Broker b : brokers) {
            this.brokerIds.add(b.brokerId);
            b.rackOpt.ifPresent(this.consecutiveBrokerRacks::add);
            b.cellOpt.ifPresent(cell -> {
                this.consecutiveBrokerCells.add((String)cell);
                this.cellsByBrokerId.put(b.brokerId, (String)cell);
                if (!this.racksByCellId.containsKey(cell)) {
                    this.racksByCellId.put((String)cell, new HashSet());
                }
                b.rackOpt.ifPresent(rack -> this.racksByCellId.get(cell).add((String)rack));
            });
        }
        this.uniqueRacks = new HashSet<String>(this.consecutiveBrokerRacks);
        this.uniqueCells = new HashSet<String>(this.consecutiveBrokerCells);
    }

    public int brokerCount() {
        return this.brokers.size();
    }

    public List<String> consecutiveRacks() {
        return new ArrayList<String>(this.consecutiveBrokerRacks);
    }

    public Set<String> uniqueRacks() {
        return new HashSet<String>(this.uniqueRacks);
    }

    public List<String> consecutiveCells() {
        return new ArrayList<String>(this.consecutiveBrokerCells);
    }

    public Map<Integer, String> cellsByBrokerId() {
        return new HashMap<Integer, String>(this.cellsByBrokerId);
    }

    public Map<String, Set<String>> uniqueRacksByCellId() {
        return new HashMap<String, Set<String>>(this.racksByCellId);
    }

    public Set<String> uniqueCells() {
        return new HashSet<String>(this.uniqueCells);
    }

    public Set<Integer> brokerIds() {
        return new HashSet<Integer>(this.brokerIds);
    }

    public static TestCluster create(Broker ... brokers) {
        return new TestCluster(Arrays.stream(brokers).collect(Collectors.toList()));
    }

    public static class Broker {
        public int brokerId;
        public Optional<String> rackOpt;
        public Optional<String> cellOpt;

        public Broker(int brokerId, Optional<String> rack, Optional<String> cell) {
            this.brokerId = brokerId;
            this.rackOpt = rack;
            this.cellOpt = cell;
        }
    }

    public static class BrokerBuilder {
        public final int brokerId;
        public Optional<String> rack = Optional.empty();
        public Optional<String> cell = Optional.empty();

        public BrokerBuilder(int brokerId) {
            this.brokerId = brokerId;
        }

        public BrokerBuilder setCell(String cell) {
            this.cell = Optional.ofNullable(cell);
            return this;
        }

        public BrokerBuilder setRack(String rack) {
            this.rack = Optional.ofNullable(rack);
            return this;
        }

        public Broker build() {
            return new Broker(this.brokerId, this.rack, this.cell);
        }
    }
}

