/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsOptions;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.CellNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ResourceNotFoundException;
import org.apache.kafka.common.errors.TenantNotFoundException;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.common.message.DescribeCellMigrationResponseData;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:11"), @Tag(value="bazel:size:large")})
class MultiTenantCellsIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    private static final short CELL_SIZE = 3;
    private static final short ERROR_CODE_PROHIBITED_MOVEMENT = 42;

    MultiTenantCellsIntegrationTest() {
    }

    @Override
    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        super.setUpTempDir(testInfo);
    }

    @Override
    protected void createPhysicalAndLogicalClusters() {
        super.createPhysicalAndLogicalClusters();
        this.awaitMetadataPropagation();
    }

    @Override
    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        super.createPhysicalAndLogicalClusters(brokerProperties);
        this.awaitMetadataPropagation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testDescribeCellsIfCellsDisabled(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.nodeProps());
        Assertions.assertEquals((Object)new DescribeCellsResponseData(), (Object)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testDescribeCells(String quorum) throws Exception {
        int brokerCount = 10;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        DescribeCellsResponseData response = (DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(6, 7, 8)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(3).setBrokers(Collections.singletonList(9)).setOpenForTenantAssignment(false).setState(CellState.READY.code()));
        Assertions.assertEquals((Object)new DescribeCellsResponseData().setCells(expectedCells).setCellsEnabled(true), (Object)response);
        response = (DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Arrays.asList(0, 2, 3)).value().get();
        expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(6, 7, 8)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(3).setBrokers(Collections.singletonList(9)).setOpenForTenantAssignment(false).setState(CellState.READY.code()));
        Assertions.assertEquals((Object)new DescribeCellsResponseData().setCells(expectedCells).setCellsEnabled(true), (Object)response);
        TestUtils.assertFutureThrows(CellNotFoundException.class, (Future)this.physicalCluster.superConfluentAdmin().describeCells(Arrays.asList(100, 101, 102)).value());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testDescribeCellsWithMigrationStates(String quorum) throws Exception {
        int brokerCount = 10;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INITIATED).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
        DescribeCellsResponseData response = (DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(6, 7, 8)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(3).setBrokers(Collections.singletonList(9)).setOpenForTenantAssignment(false).setState(CellState.READY.code()));
        Assertions.assertEquals((Object)new DescribeCellsResponseData().setCells(expectedCells).setCellsEnabled(true), (Object)response);
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2), false).value().get();
        expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.emptyList()).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(6, 7, 8)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(3).setBrokers(Collections.singletonList(9)).setOpenForTenantAssignment(false).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(-1).setBrokers(Arrays.asList(0, 1, 2)).setOpenForTenantAssignment(true).setState(CellState.READY.code()));
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        Assertions.assertEquals(expectedCells, (Object)cells);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INACTIVE).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.emptyList()).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(6, 7, 8)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(3).setBrokers(Collections.singletonList(9)).setOpenForTenantAssignment(false).setState(CellState.READY.code()));
        cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        Assertions.assertEquals(expectedCells, (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testDeleteCell(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        TestUtils.waitForCondition(() -> ((Set)client.listTopics().names().get()).containsAll(Collections.singletonList(topicName)), (String)String.format("Could not list topic %s in time", topicName));
        this.physicalCluster.superConfluentAdmin().assignTenantsToCells(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(0)))).value().get();
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().deleteCell(0).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2), false).value());
        this.physicalCluster.superConfluentAdmin().deleteTenants(Collections.singletonList(this.logicalCluster2.logicalClusterId())).value().get();
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1), true).value().get();
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().deleteCell(0).value());
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2), false).value().get();
        this.physicalCluster.superConfluentAdmin().deleteCell(0).value().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(6, 7, 8)).setOpenForTenantAssignment(true).setState(CellState.READY.code()));
        Assertions.assertEquals(expectedCells, (Object)cells);
        TestUtils.assertFutureThrows(CellNotFoundException.class, (Future)this.physicalCluster.superConfluentAdmin().deleteCell(0).value());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testDeleteCellWithTenantAssignedToMultipleCells(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        TestUtils.waitForCondition(() -> ((Set)client.listTopics().names().get()).containsAll(Collections.singletonList(topicName)), (String)String.format("Could not list topic %s in time", topicName));
        this.physicalCluster.superConfluentAdmin().assignTenantsToCells(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0, 1)))).value().get();
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().deleteCell(0).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2), false).value());
        this.physicalCluster.superConfluentAdmin().deleteTenants(Collections.singletonList(this.logicalCluster2.logicalClusterId())).value().get();
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2), false).value().get();
        this.physicalCluster.superConfluentAdmin().deleteCell(0).value().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(6, 7, 8)).setOpenForTenantAssignment(true).setState(CellState.READY.code()));
        Assertions.assertEquals(expectedCells, (Object)cells);
        TestUtils.assertFutureThrows(CellNotFoundException.class, (Future)this.physicalCluster.superConfluentAdmin().deleteCell(0).value());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testCreateCell(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        this.physicalCluster.superConfluentAdmin().createCell(1, CellState.QUARANTINED).value().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Collections.emptyList()).setState(CellState.QUARANTINED.code()));
        Assertions.assertEquals(expectedCells, (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testImplicitCellCreation(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.implicit.creation.enable", (Object)false);
        this.createPhysicalAndLogicalClusters(props);
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        Assertions.assertEquals(Collections.emptyList(), (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testImplicitCellCreationK2(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.implicit.creation.enable", (Object)true);
        props.put("confluent.cells.k2.base.broker.index", (Object)3);
        this.createPhysicalAndLogicalClusters(props);
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setOpenForTenantAssignment(true).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(1000).setBrokers(Arrays.asList(3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.QUARANTINED.code()));
        Assertions.assertEquals(expectedCells, (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testCreateCellInvalidRequest(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().createCell(0, CellState.READY).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().createCell(1, CellState.READY).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().createCell(2, CellState.READY).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().createCell(-1, CellState.READY).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().createCell(3, CellState.UNKNOWN).value());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAlterCell(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        this.physicalCluster.superConfluentAdmin().alterCell(0, CellState.QUARANTINED).value().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.QUARANTINED.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAlterCellInvalidRequest(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        TestUtils.assertFutureThrows(CellNotFoundException.class, (Future)this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.READY).value());
        TestUtils.assertFutureThrows(CellNotFoundException.class, (Future)this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.UNKNOWN).value());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignBrokersToCell(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)6);
        this.createPhysicalAndLogicalClusters(props);
        this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(3, 4, 5), 0, false).value().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Collections.emptyList()).setState(CellState.READY.code()).setOpenForTenantAssignment(false));
        Assertions.assertEquals(expectedCells, (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignBrokersToCellForce(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)6);
        this.createPhysicalAndLogicalClusters(props);
        this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(3, 4), 0, true).value().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2, 3, 4)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Collections.singletonList(5)).setState(CellState.READY.code()).setOpenForTenantAssignment(false));
        Assertions.assertEquals(expectedCells, (Object)cells);
        this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(3, 4, 5), 1, false).value().get();
        cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignBrokersToCellInvalidRequest(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)6);
        props.put("confluent.cells.min.size", (Object)2);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        this.physicalCluster.superConfluentAdmin().assignTenantsToCells(Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setCellIds(Collections.singletonList(0)).setTenantId(this.logicalCluster1.logicalClusterId()))).value().get();
        TestUtils.assertFutureThrows(CellNotFoundException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(3, 4, 5), 10, false).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(3, 4), 0, false).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(0, 1, 2), 1, false).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(0, 1, 2), 1, true).value());
        this.physicalCluster.superConfluentAdmin().deleteTenants(Collections.singletonList(this.logicalCluster1.logicalClusterId())).value().get();
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(0, 1, 2, 3), 1, false).value());
        this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(0, 1, 2), 2, false).value().get();
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(3, 4, 5), 2, false).value());
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.emptyList()).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(0, 1, 2, 6, 7, 8)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignBrokersToCellInvalidRequestWithTenantAssignedToMultipleCells(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)6);
        props.put("confluent.cells.min.size", (Object)2);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        this.physicalCluster.superConfluentAdmin().assignTenantsToCells(Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setCellIds(Arrays.asList(0, 2)).setTenantId(this.logicalCluster1.logicalClusterId()))).value().get();
        TestUtils.assertFutureThrows(CellNotFoundException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(3, 4, 5), 10, false).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(3, 4), 0, false).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(6, 7, 8), 1, false).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(6, 7, 8), 1, true).value());
        this.physicalCluster.superConfluentAdmin().deleteTenants(Collections.singletonList(this.logicalCluster1.logicalClusterId())).value().get();
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(0, 1, 2, 3), 1, false).value());
        this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(6, 7, 8), 1, false).value().get();
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(0, 1, 2), 1, false).value());
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5, 6, 7, 8)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Collections.emptyList()).setState(CellState.READY.code()).setOpenForTenantAssignment(false));
        Assertions.assertEquals(expectedCells, (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testUnassignBrokersFromCell(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2), false).value().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.emptyList()).setState(CellState.READY.code()));
        Assertions.assertEquals(expectedCells, (Object)cells);
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(3, 4, 5), false).value().get();
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testUnassignBrokersFromCellForce(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1), false).value());
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1), true).value().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(2)).setState(CellState.READY.code()));
        Assertions.assertEquals(expectedCells, (Object)cells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testUnassignBrokersFromCellInvalidRequest(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2), false).value());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1), false).value());
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
        this.physicalCluster.superConfluentAdmin().deleteTenants(Collections.singletonList(this.logicalCluster1.logicalClusterId())).value().get();
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2), false).value().get();
        List emptyCells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedEmptyCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.emptyList()).setState(CellState.READY.code()));
        Assertions.assertEquals(expectedEmptyCells, (Object)emptyCells);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCell(String quorum) throws Exception {
        int brokerCount = 15;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient firstTenantClient = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        AdminClient secondTenantClient = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        for (AdminClient client : Arrays.asList(firstTenantClient, secondTenantClient)) {
            String topicName = "testtopicname";
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
            client.createTopics(topics).all().get();
        }
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Collections.singletonList(3)), new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(4)), new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-nonexistent").setCellIds(Collections.singletonList(0)));
        List failedTenants = (List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(assignments).value().get();
        Assertions.assertEquals((int)1, (int)failedTenants.size());
        Assertions.assertEquals((short)Errors.TENANT_NOT_FOUND.code(), (short)((AssignTenantsToCellResponseData.TenantAssignmentErrors)failedTenants.get(0)).error());
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(3)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(4)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellWithTenantAssignedToMultipleCells(String quorum) throws Exception {
        int brokerCount = 15;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient firstTenantClient = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        AdminClient secondTenantClient = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        for (AdminClient client : Arrays.asList(firstTenantClient, secondTenantClient)) {
            String topicName = "testtopicname";
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
            client.createTopics(topics).all().get();
        }
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Collections.singletonList(3)), new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(3, 4)), new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-nonexistent").setCellIds(Collections.singletonList(0)));
        List failedTenants = (List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(assignments).value().get();
        Assertions.assertEquals((int)1, (int)failedTenants.size());
        Assertions.assertEquals((short)Errors.TENANT_NOT_FOUND.code(), (short)((AssignTenantsToCellResponseData.TenantAssignmentErrors)failedTenants.get(0)).error());
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(3)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(3, 4)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellWithMigrationEnabled(String quorum) throws Exception {
        int brokerCount = 15;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient firstTenantClient = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        AdminClient secondTenantClient = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        for (AdminClient client : Arrays.asList(firstTenantClient, secondTenantClient)) {
            String topicName = "testtopicname";
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
            client.createTopics(topics).all().get();
        }
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INITIATED).value().get();
        String migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Collections.singletonList(3)), new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(3, 4)), new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("lkc-nonexistent").setCellIds(Collections.singletonList(0)));
        List failedTenants = (List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(assignments).value().get();
        Assertions.assertEquals((int)0, (int)failedTenants.size());
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        ArrayList<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptionsKraft = new ArrayList<DescribeTenantsResponseData.TenantDescription>(Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId("lkc-nonexistent").setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(3)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(3, 4)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue())));
        if (quorum.equals("kraft")) {
            Assertions.assertEquals(expectedTenantDescriptionsKraft, (Object)tenantDescriptions);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellToCellNotOpenForAssignmentDueToMinCellSizeConstraint(String quorum) throws Exception {
        int brokerCount = 5;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.min.size", (Object)3);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)2);
        props.put("default.replication.factor", (Object)2);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 2));
        client.createTopics(topics).all().get();
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Collections.singletonList(1)));
        List errors = (List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(assignments).value().get();
        List<AssignTenantsToCellResponseData.TenantAssignmentErrors> expectedErrors = Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(this.logicalCluster1.logicalClusterId()).setError(Errors.INVALID_REQUEST.code()).setErrorMessage("Tenant lkc-tenant1 cannot be moved to cells 1 since the cells either does not have enough brokers to meet its minSize or does not have at least 2 alive brokers").setCellIds(Collections.singletonList(1)));
        Assertions.assertEquals(expectedErrors, (Object)errors);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellsToCellNotOpenForAssignmentDueToMinCellSizeConstraint(String quorum) throws Exception {
        int brokerCount = 5;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.min.size", (Object)3);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)2);
        props.put("default.replication.factor", (Object)2);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 2));
        client.createTopics(topics).all().get();
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0, 1)));
        List errors = (List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(assignments).value().get();
        List<AssignTenantsToCellResponseData.TenantAssignmentErrors> expectedErrors = Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(this.logicalCluster1.logicalClusterId()).setError(Errors.INVALID_REQUEST.code()).setErrorMessage("Tenant lkc-tenant1 cannot be moved to cells 1 since the cells either does not have enough brokers to meet its minSize or does not have at least 2 alive brokers").setCellIds(Arrays.asList(0, 1)));
        Assertions.assertEquals(expectedErrors, (Object)errors);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellToCellNotOpenForAssignmentDueToReplicationFactorConstraint(String quorum) throws Exception {
        int brokerCount = 5;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.min.size", (Object)2);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)3);
        props.put("default.replication.factor", (Object)3);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Collections.singletonList(1)));
        List errors = (List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(assignments).value().get();
        List<AssignTenantsToCellResponseData.TenantAssignmentErrors> expectedErrors = Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(this.logicalCluster1.logicalClusterId()).setError(Errors.INVALID_REQUEST.code()).setErrorMessage("Tenant lkc-tenant1 cannot be moved to cells 1 since the cells either does not have enough brokers to meet its minSize or does not have at least 3 alive brokers").setCellIds(Collections.singletonList(1)));
        Assertions.assertEquals(expectedErrors, (Object)errors);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellsToCellNotOpenForAssignmentDueToReplicationFactorConstraint(String quorum) throws Exception {
        int brokerCount = 5;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.min.size", (Object)2);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)3);
        props.put("default.replication.factor", (Object)3);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0, 1)));
        List errors = (List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(assignments).value().get();
        List<AssignTenantsToCellResponseData.TenantAssignmentErrors> expectedErrors = Collections.singletonList(new AssignTenantsToCellResponseData.TenantAssignmentErrors().setTenantId(this.logicalCluster1.logicalClusterId()).setError(Errors.INVALID_REQUEST.code()).setErrorMessage("Tenant lkc-tenant1 cannot be moved to cells 1 since the cells either does not have enough brokers to meet its minSize or does not have at least 3 alive brokers").setCellIds(Arrays.asList(0, 1)));
        Assertions.assertEquals(expectedErrors, (Object)errors);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellQuarantinedState(String quorum) throws Exception {
        int brokerCount = 4;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)((short)brokerCount));
        props.put("confluent.cells.default.size", (Object)1);
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)1);
        props.put("default.replication.factor", (Object)1);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        this.physicalCluster.superConfluentAdmin().alterCell(0, CellState.QUARANTINED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.EXCLUDED).value().get();
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 1));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster2.user(22), Collections.singletonList(topicName));
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        Assertions.assertEquals((int)1, (int)tenantDescriptions.size());
        Assertions.assertTrue(((Integer)((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(0)).cellIds().get(0) != 0 && (Integer)((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(0)).cellIds().get(0) != 1 ? 1 : 0) != 0);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> quarantineAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(0)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(quarantineAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> quarantineForceAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(0)).setForce(true));
        this.physicalCluster.superConfluentAdmin().assignTenantsToCells(quarantineForceAssignment).value();
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(0)));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(3)));
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> exclusionAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(1)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyAssignment).value().get()).size());
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(exclusionAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyForceAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(3)).setForce(true));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyForceAssignment).value().get()).size());
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> lastExpectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(3)));
        Assertions.assertEquals(lastExpectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellsQuarantinedState(String quorum) throws Exception {
        int brokerCount = 4;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)((short)brokerCount));
        props.put("confluent.cells.default.size", (Object)1);
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)1);
        props.put("default.replication.factor", (Object)1);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        this.physicalCluster.superConfluentAdmin().alterCell(0, CellState.QUARANTINED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.EXCLUDED).value().get();
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 1));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster2.user(22), Collections.singletonList(topicName));
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        Assertions.assertEquals((int)1, (int)tenantDescriptions.size());
        Assertions.assertTrue(((Integer)((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(0)).cellIds().get(0) != 0 && (Integer)((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(0)).cellIds().get(0) != 1 ? 1 : 0) != 0);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> quarantineAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0, 2)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(quarantineAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> quarantineForceAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0, 2)).setForce(true));
        this.physicalCluster.superConfluentAdmin().assignTenantsToCells(quarantineForceAssignment).value();
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(0, 2)));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(2, 3)));
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> exclusionAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(1, 2)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyAssignment).value().get()).size());
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(exclusionAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyForceAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(2, 3)).setForce(true));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyForceAssignment).value().get()).size());
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> lastExpectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(2, 3)));
        Assertions.assertEquals(lastExpectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantToMultipleCellsAllInQuarantinedState(String quorum) throws Exception {
        int brokerCount = 4;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)((short)brokerCount));
        props.put("confluent.cells.default.size", (Object)1);
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)1);
        props.put("default.replication.factor", (Object)1);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        this.physicalCluster.superConfluentAdmin().alterCell(0, CellState.QUARANTINED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.QUARANTINED).value().get();
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 10, 1));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster2.user(22), Collections.singletonList(topicName));
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        Assertions.assertEquals((int)1, (int)tenantDescriptions.size());
        Assertions.assertTrue((!((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(0)).cellIds().contains(0) && !((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(0)).cellIds().contains(1) ? 1 : 0) != 0);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> quarantineAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0, 1)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(quarantineAssignment).value().get()).size());
        Assertions.assertEquals((short)42, (short)((AssignTenantsToCellResponseData.TenantAssignmentErrors)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(quarantineAssignment).value().get()).get(0)).error());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> quarantineForceAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0, 1)).setForce(true));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(quarantineForceAssignment).value().get()).size());
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(0, 1)));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(2, 3)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyAssignment).value().get()).size());
        Assertions.assertEquals((short)42, (short)((AssignTenantsToCellResponseData.TenantAssignmentErrors)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyAssignment).value().get()).get(0)).error());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyForceAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(2, 3)).setForce(true));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyForceAssignment).value().get()).size());
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> lastExpectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(2, 3)));
        Assertions.assertEquals(lastExpectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantToMultipleCellsAllInExcludedState(String quorum) throws Exception {
        int brokerCount = 4;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)((short)brokerCount));
        props.put("confluent.cells.default.size", (Object)1);
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)1);
        props.put("default.replication.factor", (Object)1);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        this.physicalCluster.superConfluentAdmin().alterCell(0, CellState.EXCLUDED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.EXCLUDED).value().get();
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 10, 1));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster2.user(22), Collections.singletonList(topicName));
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        Assertions.assertEquals((int)1, (int)tenantDescriptions.size());
        Assertions.assertTrue((!((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(0)).cellIds().contains(0) && !((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(0)).cellIds().contains(1) ? 1 : 0) != 0);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> excludedAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0, 1)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(excludedAssignment).value().get()).size());
        Assertions.assertEquals((short)42, (short)((AssignTenantsToCellResponseData.TenantAssignmentErrors)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(excludedAssignment).value().get()).get(0)).error());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> excludedForceAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0, 1)).setForce(true));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(excludedForceAssignment).value().get()).size());
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(0, 1)));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyAssignment = Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(2, 3)));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyAssignment).value().get()).size());
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantReadyCellDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(2, 3)));
        Assertions.assertEquals(expectedTenantReadyCellDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToMultipleCellsMixedState(String quorum) throws Exception {
        int brokerCount = 5;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)((short)brokerCount));
        props.put("confluent.cells.default.size", (Object)1);
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)1);
        props.put("default.replication.factor", (Object)1);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 6, 1));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster2.user(22), Collections.singletonList(topicName));
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignRequest = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0, 1, 2)));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(assignRequest).value().get()).size());
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.QUARANTINED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(2, CellState.EXCLUDED).value().get();
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        Assertions.assertEquals((int)1, (int)tenantDescriptions.size());
        Assertions.assertEquals(Arrays.asList(0, 1, 2), (Object)((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(0)).cellIds());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(3, 4)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyAssignment).value().get()).size());
        Assertions.assertEquals((short)42, (short)((AssignTenantsToCellResponseData.TenantAssignmentErrors)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyAssignment).value().get()).get(0)).error());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyForceAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(3, 4)).setForce(true));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyForceAssignment).value().get()).size());
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> lastExpectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(3, 4)));
        Assertions.assertEquals(lastExpectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellExcludedState(String quorum) throws Exception {
        int brokerCount = 10;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)((short)brokerCount));
        props.put("confluent.cells.default.size", (Object)1);
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)1);
        props.put("default.replication.factor", (Object)1);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        this.physicalCluster.superConfluentAdmin().alterCell(0, CellState.QUARANTINED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.EXCLUDED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(2, CellState.EXCLUDED).value().get();
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 1));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster2.user(22), Collections.singletonList(topicName));
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> excludedAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(1)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(excludedAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> excludedForceAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(1)).setForce(true));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(excludedForceAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> anotherExcludedAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(2)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(anotherExcludedAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> quarantineAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(0)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(quarantineAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(4)));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyAssignment).value().get()).size());
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> lastExpectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(4)));
        Assertions.assertEquals(lastExpectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAssignTenantsToCellsExcludedState(String quorum) throws Exception {
        int brokerCount = 10;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)((short)brokerCount));
        props.put("confluent.cells.default.size", (Object)1);
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)1);
        props.put("default.replication.factor", (Object)1);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        this.physicalCluster.superConfluentAdmin().alterCell(0, CellState.QUARANTINED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.EXCLUDED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(2, CellState.EXCLUDED).value().get();
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 1));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster2.user(22), Collections.singletonList(topicName));
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> excludedAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(1, 3)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(excludedAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> excludedForceAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(1, 3)).setForce(true));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(excludedForceAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> anotherExcludedAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(2, 3)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(anotherExcludedAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> quarantineAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0, 3)));
        Assertions.assertEquals((int)1, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(quarantineAssignment).value().get()).size());
        List<AssignTenantsToCellRequestData.TenantToCellAssignment> readyAssignment = Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(3, 4)));
        Assertions.assertEquals((int)0, (int)((List)this.physicalCluster.superConfluentAdmin().assignTenantsToCells(readyAssignment).value().get()).size());
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> lastExpectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()).setCellIds(Arrays.asList(3, 4)));
        Assertions.assertEquals(lastExpectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testPartitionsInTenantCell(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        HashMap<Integer, List<Integer>> cellIdToExpectedBrokers = new HashMap<Integer, List<Integer>>();
        cellIdToExpectedBrokers.put(0, Arrays.asList(0, 1, 2));
        cellIdToExpectedBrokers.put(1, Arrays.asList(3, 4, 5));
        cellIdToExpectedBrokers.put(2, Arrays.asList(6, 7, 8));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster1.user(9), Collections.singletonList(topicName));
        Map topicDescriptions = (Map)client.describeTopics(Collections.singleton(topicName)).allTopicNames().get();
        TopicDescription topicDescription = (TopicDescription)topicDescriptions.get(topicName);
        int cellId = (Integer)((DescribeTenantsResponseData.TenantDescription)((List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.singletonList(this.logicalCluster1.logicalClusterId())).value().get()).get(0)).cellIds().get(0);
        List expectedBrokers = (List)cellIdToExpectedBrokers.get(cellId);
        List replicas = ((TopicPartitionInfo)topicDescription.partitions().get(0)).replicas().stream().mapToInt(Node::id).sorted().boxed().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)topicDescription.partitions().size());
        Assertions.assertEquals((Object)expectedBrokers, replicas);
        List topicIds = IntStream.range(0, 3).mapToObj(i -> "testtopicname" + i).collect(Collectors.toList());
        for (String currentTopic : topicIds) {
            client.createTopics(Collections.singletonList(new NewTopic(currentTopic, 1, 3))).all().get();
            int tenantCellId = (Integer)((DescribeTenantsResponseData.TenantDescription)((List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.singletonList(this.logicalCluster1.logicalClusterId())).value().get()).get(0)).cellIds().get(0);
            List currentReplicas = ((TopicPartitionInfo)topicDescription.partitions().get(0)).replicas().stream().mapToInt(Node::id).sorted().boxed().collect(Collectors.toList());
            Assertions.assertEquals((Object)expectedBrokers, currentReplicas);
            Assertions.assertEquals((int)tenantCellId, (int)cellId);
        }
        this.ensureTenantPartitionsWithinCell(this.logicalCluster1.user(9), Stream.concat(Stream.of(topicName), topicIds.stream()).collect(Collectors.toList()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testPartitionsInTenantCellLargeCluster(String quorum) throws Exception {
        int cellSize = 6;
        int brokerCount = cellSize * 3;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)((short)brokerCount));
        props.put("confluent.cells.default.size", (Object)((short)cellSize));
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        List<String> topics = IntStream.range(0, 10).mapToObj(i -> "testtopicname" + i).collect(Collectors.toList());
        for (String topicName : topics) {
            client.createTopics(Collections.singletonList(new NewTopic(topicName, 1, 3))).all().get();
        }
        this.ensureTenantPartitionsWithinCell(this.logicalCluster1.user(9), topics);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testPartitionInTenantAfterCellExpansion(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)6);
        this.createPhysicalAndLogicalClusters(props);
        List<Integer> expansionBrokers = Arrays.asList(3, 4, 5);
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(expansionBrokers, false).value().get();
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopic";
        client.createTopics(Collections.singletonList(new NewTopic(topicName, 100, 3))).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster1.user(9), Collections.singletonList(topicName));
        this.physicalCluster.superConfluentAdmin().assignBrokersToCell(expansionBrokers, 0, true).value().get();
        String secondTopicName = "testtopic2";
        client.createTopics(Collections.singletonList(new NewTopic(secondTopicName, 100, 3))).all().get();
        List<String> topicIds = Arrays.asList(topicName, secondTopicName);
        this.ensureTenantPartitionsWithinCell(this.logicalCluster1.user(9), topicIds);
        TestUtils.waitForCondition(() -> ((Set)client.listTopics().names().get()).containsAll(topicIds), (String)String.format("Could not list topics %s in time", topicIds));
        Map topicNameAndDescriptions = (Map)client.describeTopics(topicIds).allTopicNames().get();
        List<Integer> replicaCountsForSecondTopic = IntStream.range(0, brokerCount).map(i -> 0).boxed().collect(Collectors.toList());
        TopicDescription secondTopic = (TopicDescription)topicNameAndDescriptions.get(secondTopicName);
        for (TopicPartitionInfo partitionInfo : secondTopic.partitions()) {
            for (Node node : partitionInfo.replicas()) {
                replicaCountsForSecondTopic.set(node.id(), (Integer)replicaCountsForSecondTopic.get(node.id()) + 1);
            }
        }
        replicaCountsForSecondTopic.forEach(count -> Assertions.assertTrue((Math.abs(count - 50) <= 1 ? 1 : 0) != 0));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testCreateTopicWithDeadBroker(String quorum) throws Exception {
        int brokerCount = 15;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster1.user(9), Collections.singletonList(topicName));
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.singletonList(this.logicalCluster1.user((int)9).logicalClusterId)).value().get();
        DescribeTenantsResponseData.TenantDescription tenantDescription = tenantDescriptions.stream().filter(t -> t.tenantId().equals(this.logicalCluster1.user((int)9).logicalClusterId)).findFirst().get();
        DescribeCellsResponseData.Cell cell = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.singletonList((Integer)tenantDescription.cellIds().get(0))).value().get()).cells().stream().filter(c -> c.cellId() == ((Integer)tenantDescription.cellIds().get(0)).intValue()).findFirst().get();
        this.physicalCluster.kafkaCluster().kafkaBrokers().get((Integer)cell.brokers().get(0)).shutdown();
        String secondTopicName = "testtopicname2";
        List<NewTopic> newTopics = Collections.singletonList(new NewTopic(secondTopicName, 1, 3));
        client.createTopics(newTopics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster1.user(9), Arrays.asList(topicName, secondTopicName));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testCreateTopicWithDeadBrokerFromHighMinSizeNumBrokers(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.min.size", (Object)6);
        props.put("confluent.cells.default.size", (Object)6);
        props.put("confluent.cells.max.size", (Object)6);
        this.createPhysicalAndLogicalClusters(props);
        this.physicalCluster.kafkaCluster().kafkaBrokers().get(0).shutdown();
        this.physicalCluster.kafkaCluster().kafkaBrokers().get(1).shutdown();
        this.physicalCluster.kafkaCluster().kafkaBrokers().get(2).shutdown();
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testCreateTopicWithExcludedBroker(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        HashMap<Integer, ExclusionOp> operations = new HashMap<Integer, ExclusionOp>();
        operations.put(0, new ExclusionOp(ExclusionOp.OpType.SET));
        this.physicalCluster.superConfluentAdmin().alterBrokerReplicaExclusions(operations).result().get();
        TestUtils.waitForCondition(() -> {
            List exclusions = (List)this.physicalCluster.superConfluentAdmin().describeBrokerReplicaExclusions(new DescribeBrokerReplicaExclusionsOptions()).descriptions().get();
            return exclusions.size() == 1;
        }, (String)"Could not wait for broker 0 to become excluded");
        AdminClient secondClient = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        TestUtils.assertFutureThrows(ResourceNotFoundException.class, (Future)secondClient.createTopics(Collections.singletonList(new NewTopic("testtopicname", 1, 3))).all());
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> firstExpectedTenantDescriptions = Collections.singletonList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(firstExpectedTenantDescriptions, (Object)tenantDescriptions);
        HashMap<Integer, ExclusionOp> newOperations = new HashMap<Integer, ExclusionOp>();
        newOperations.put(0, new ExclusionOp(ExclusionOp.OpType.DELETE));
        this.physicalCluster.superConfluentAdmin().alterBrokerReplicaExclusions(newOperations).result().get();
        TestUtils.waitForCondition(() -> {
            List exclusions = (List)this.physicalCluster.superConfluentAdmin().describeBrokerReplicaExclusions(new DescribeBrokerReplicaExclusionsOptions()).descriptions().get();
            return exclusions.isEmpty();
        }, (String)"Could not wait for broker 0 to become promoted");
        secondClient.createTopics(Collections.singletonList(new NewTopic("testtopicname", 1, 3))).all().get();
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testRoundRobinCellPlacement(String quorum) throws Exception {
        int brokerCount = 15;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            LogicalCluster logicalCluster = this.physicalCluster.createLogicalCluster("lkc-tenant" + c, 100 + c, 1000 + c);
            AdminClient client = this.testHarness.createAdminClient(logicalCluster.user(1000 + c));
            client.createTopics(Collections.singletonList(new NewTopic("testtopic", 1, 3))).all().get();
        }
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        Assertions.assertEquals((int)26, (int)tenantDescriptions.size());
        int numCells = brokerCount / 3;
        for (int i = 0; i < tenantDescriptions.size() - 1; ++i) {
            int expectedCell = ((Integer)((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(i)).cellIds().get(0) + 1) % numCells;
            int actualCell = (Integer)((DescribeTenantsResponseData.TenantDescription)tenantDescriptions.get(i + 1)).cellIds().get(0);
            Assertions.assertEquals((int)actualCell, (int)expectedCell);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testPartitionInCellAfterPartitionCreations(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        this.ensureTenantPartitionsWithinCell(this.logicalCluster2.user(22), Collections.singletonList(topicName));
        HashMap<String, NewPartitions> newPartitions = new HashMap<String, NewPartitions>();
        newPartitions.put(topicName, NewPartitions.increaseTo((int)100));
        client.createPartitions(newPartitions).all().get();
        TestUtils.waitForCondition(() -> {
            Map topicNameAndDescriptions = (Map)client.describeTopics(Collections.singletonList(topicName)).allTopicNames().get();
            return ((TopicDescription)topicNameAndDescriptions.get(topicName)).partitions().size() == 100;
        }, (String)"Could not wait for topic to have 100 partitions");
        this.ensureTenantPartitionsWithinCell(this.logicalCluster2.user(22), Collections.singletonList(topicName));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testPartitionAssignmentUsesReplicationFactor(String quorum) throws Exception {
        int brokerCount = 4;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)((short)brokerCount));
        props.put("confluent.cells.default.size", (Object)2);
        props.put("confluent.cells.min.size", (Object)2);
        this.createPhysicalAndLogicalClusters(props);
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        TestUtils.assertFutureThrows(ResourceNotFoundException.class, (Future)client.createTopics(Collections.singletonList(new NewTopic("testtopicname", 1, 3))).all());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testDescribeTenants(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient firstTenantClient = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        AdminClient secondTenantClient = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        for (AdminClient client : Arrays.asList(firstTenantClient, secondTenantClient)) {
            String topicName = "testtopicname";
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
            client.createTopics(topics).all().get();
        }
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        Set uniqueCellIds = tenantDescriptions.stream().flatMap(tenant -> tenant.cellIds().stream()).collect(Collectors.toSet());
        Assertions.assertEquals((int)2, (int)tenantDescriptions.size());
        Assertions.assertTrue((boolean)tenantDescriptions.stream().anyMatch(t -> this.logicalCluster1.logicalClusterId().equals(t.tenantId())));
        Assertions.assertTrue((boolean)tenantDescriptions.stream().anyMatch(t -> this.logicalCluster2.logicalClusterId().equals(t.tenantId())));
        Assertions.assertTrue((boolean)tenantDescriptions.stream().allMatch(t -> 0 <= (Integer)t.cellIds().get(0) && (Integer)t.cellIds().get(0) <= 2));
        Assertions.assertEquals((int)2, (int)uniqueCellIds.size());
        Assertions.assertTrue((boolean)tenantDescriptions.stream().allMatch(t -> t.partitionPlacementStrategy() == PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        TestUtils.assertFutureThrows(TenantNotFoundException.class, (Future)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.singletonList("lkc-abcd")).value());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testDeleteTenants(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient tenantClient = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        AdminClient secondTenantClient = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        String topicName = "testtopicname";
        for (AdminClient client : Arrays.asList(tenantClient, secondTenantClient)) {
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
            client.createTopics(topics).all().get();
        }
        for (AdminClient client : Arrays.asList(tenantClient, secondTenantClient)) {
            client.deleteTopics(Collections.singletonList(topicName)).all().get();
        }
        List<String> tenantIdsToDelete = Arrays.asList(this.logicalCluster1.logicalClusterId(), this.logicalCluster2.logicalClusterId(), "lkc-nonexistent");
        List tenantsWithTopics = (List)this.physicalCluster.superConfluentAdmin().deleteTenants(tenantIdsToDelete).value().get();
        Assertions.assertEquals(Collections.emptyList(), (Object)tenantsWithTopics);
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        Assertions.assertEquals(Collections.emptyList(), (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testHealthcheckTenantPartitionInCell(String quorum) throws Exception {
        int brokerCount = 15;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        List<String> topics = Arrays.asList("testtopic", "testtopic2");
        this.testTopicsCreatedPartitionInCell((Admin)this.testHarness.createAdminClient(this.logicalCluster1.adminUser()), topics);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testSystemTopicPartitionInCell(String quorum) throws Exception {
        int brokerCount = 15;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        List<String> internalTopics = Arrays.asList("__consumer_offsets", "__transaction_state", "_confluent-link-metadata", "_confluent-quotas");
        this.testTopicsCreatedPartitionInCell((Admin)this.physicalCluster.superConfluentAdmin(), internalTopics);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testSystemTopicPartitionNotInQuarantinedCell(String quorum) throws Exception {
        int brokerCount = 15;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.QUARANTINED).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(2, CellState.QUARANTINED).value().get();
        List<String> internalTopics = Arrays.asList("__consumer_offsets", "__transaction_state", "_confluent-link-metadata", "_confluent-quotas");
        this.createTopics((Admin)this.physicalCluster.superConfluentAdmin(), internalTopics);
        Map topicDescriptions = (Map)this.physicalCluster.superConfluentAdmin().describeTopics(internalTopics).allTopicNames().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        Assertions.assertEquals(Collections.emptyList(), (Object)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get());
        List quarantinedBrokers = cells.stream().filter(cell -> CellState.toEnum((byte)cell.state()) == CellState.QUARANTINED).flatMap(cell -> cell.brokers().stream()).collect(Collectors.toList());
        for (String topicName : internalTopics) {
            TopicDescription topicDescription = (TopicDescription)topicDescriptions.get(topicName);
            for (TopicPartitionInfo partition : topicDescription.partitions()) {
                List nodes = partition.replicas().stream().map(Node::id).sorted().collect(Collectors.toList());
                Assertions.assertTrue((boolean)Collections.disjoint(nodes, quarantinedBrokers));
            }
        }
    }

    private void createTopics(Admin client, Collection<String> newTopics) throws InterruptedException, ExecutionException {
        for (String topicName : newTopics) {
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 15, 3));
            client.createTopics(topics).all().get();
        }
        TestUtils.waitForCondition(() -> ((Set)client.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).containsAll(newTopics), (String)String.format("Could not list topic %s in time", newTopics));
    }

    private void testTopicsCreatedPartitionInCell(Admin client, Collection<String> newTopics) throws ExecutionException, InterruptedException {
        for (String topicName : newTopics) {
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 15, 3));
            client.createTopics(topics).all().get();
        }
        TestUtils.waitForCondition(() -> ((Set)client.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).containsAll(newTopics), (String)String.format("Could not list topic %s in time", newTopics));
        Map topicDescriptions = (Map)client.describeTopics(newTopics).allTopicNames().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        Assertions.assertEquals(Collections.emptyList(), (Object)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get());
        for (String topicName : newTopics) {
            TopicDescription topicDescription = (TopicDescription)topicDescriptions.get(topicName);
            List cellsUsed = cells.stream().map(t -> 0).collect(Collectors.toList());
            for (TopicPartitionInfo partition : topicDescription.partitions()) {
                List nodes = partition.replicas().stream().map(Node::id).sorted().collect(Collectors.toList());
                Set partitionCellIds = cells.stream().filter(cell -> cell.brokers().containsAll(nodes)).map(DescribeCellsResponseData.Cell::cellId).collect(Collectors.toSet());
                Assertions.assertEquals((int)1, (int)partitionCellIds.size());
                int partitionCellId = (Integer)partitionCellIds.iterator().next();
                cellsUsed.set(partitionCellId, (Integer)cellsUsed.get(partitionCellId) + 1);
            }
            for (int cellId = 0; cellId < cellsUsed.size(); ++cellId) {
                String numberString = cellsUsed.stream().map(String::valueOf).collect(Collectors.joining(","));
                Assertions.assertTrue(((Integer)cellsUsed.get(cellId) >= 1 ? 1 : 0) != 0, (String)String.format("Expected topic %s to have a partition in cell %s. Got %s", topicName, cellId, numberString));
            }
        }
    }

    private void ensureTenantPartitionsWithinCell(LogicalClusterUser logicalClusterUser, List<String> topicIds) throws Exception {
        AdminClient client = this.testHarness.createAdminClient(logicalClusterUser);
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.singletonList(logicalClusterUser.logicalClusterId)).value().get();
        Optional<DescribeTenantsResponseData.TenantDescription> tenantDescriptionOpt = tenantDescriptions.stream().filter(t -> t.tenantId().equals(logicalClusterUser.logicalClusterId)).findFirst();
        Assertions.assertTrue((boolean)tenantDescriptionOpt.isPresent(), (String)("Expected tenant " + logicalClusterUser.logicalClusterId + " to be assigned to a cell"));
        DescribeTenantsResponseData.TenantDescription tenantDescription = tenantDescriptionOpt.get();
        Assertions.assertEquals((Object)logicalClusterUser.logicalClusterId, (Object)tenantDescription.tenantId());
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.singletonList((Integer)tenantDescription.cellIds().get(0))).value().get()).cells();
        DescribeCellsResponseData.Cell cell = cells.stream().filter(c -> c.cellId() == ((Integer)tenantDescription.cellIds().get(0)).intValue()).findFirst().get();
        String brokersString = cell.brokers().stream().map(String::valueOf).collect(Collectors.joining(","));
        TestUtils.waitForCondition(() -> ((Set)client.listTopics().names().get()).containsAll(topicIds), (String)String.format("Could not list topics %s in time", topicIds));
        Map topicNameAndDescriptions = (Map)client.describeTopics(topicIds).allTopicNames().get();
        for (Map.Entry topicNameAndDescription : topicNameAndDescriptions.entrySet()) {
            TopicDescription topicDescription = (TopicDescription)topicNameAndDescription.getValue();
            String topicName = (String)topicNameAndDescription.getKey();
            for (TopicPartitionInfo partitionInfo : topicDescription.partitions()) {
                List replicaIds = partitionInfo.replicas().stream().map(Node::id).sorted().collect(Collectors.toList());
                String replicaString = replicaIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                Assertions.assertTrue((boolean)cell.brokers().containsAll(replicaIds), (String)("Expected tenant " + logicalClusterUser.logicalClusterId + " that's assigned cell " + cell.cellId() + " to have replicas within cell brokers " + brokersString + " but has replicas " + replicaString + " in topic " + topicName + " and partition " + partitionInfo.partition()));
            }
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testAlterCellMigrationActions(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INITIATED).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.PAUSED).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"PAUSED", (Object)migrationState);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INITIATED).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INACTIVE).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.PAUSED).value());
    }

    private Properties cellProps() {
        Properties props = this.nodeProps();
        props.put("confluent.cells.enable", (Object)true);
        props.put("confluent.cells.implicit.creation.enable", (Object)true);
        props.put("confluent.topic.partition.default.placement", PartitionPlacementStrategy.TENANT_IN_CELL.code().toString());
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.cells.default.size", (Object)3);
        props.put("confluent.cells.max.size", (Object)3);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)3);
        props.put("default.replication.factor", (Object)3);
        return props;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testCreateTopics(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)6);
        props.put("confluent.cells.min.size", (Object)3);
        props.put("confluent.cells.default.size", (Object)6);
        this.createPhysicalAndLogicalClusters(props);
        DescribeCellsResponseData response = (DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get();
        List<Object> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()));
        Assertions.assertEquals((Object)new DescribeCellsResponseData().setCells(expectedCells).setCellsEnabled(true), (Object)response);
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2, 3, 4, 5), false).value().get();
        this.physicalCluster.superConfluentAdmin().deleteCell(0).value().get();
        expectedCells = Collections.emptyList();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        Assertions.assertEquals(expectedCells, (Object)cells);
        AdminClient tenant0 = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        TestUtils.assertFutureThrows(ResourceNotFoundException.class, (Future)tenant0.createTopics(Collections.singletonList(new NewTopic("topic_1", 1, 3))).all());
        this.physicalCluster.superConfluentAdmin().createCell(0, CellState.READY).value().get();
        response = (DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get();
        expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.emptyList()).setOpenForTenantAssignment(false).setState(CellState.READY.code()));
        Assertions.assertEquals(expectedCells, (Object)response.cells());
        TestUtils.assertFutureThrows(ResourceNotFoundException.class, (Future)tenant0.createTopics(Collections.singletonList(new NewTopic("topic_1", 1, 3))).all());
        this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(0, 1, 2, 3, 4, 5), 0, false).value().get();
        response = (DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get();
        expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()));
        Assertions.assertEquals(expectedCells, (Object)response.cells());
        tenant0.createTopics(Collections.singletonList(new NewTopic("topic_1", 1, 3))).all().get();
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testCreateTopicsWithMigrationEnabled(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)6);
        props.put("confluent.cells.min.size", (Object)3);
        props.put("confluent.cells.default.size", (Object)6);
        this.createPhysicalAndLogicalClusters(props);
        DescribeCellsResponseData response = (DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get();
        List<Object> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()));
        Assertions.assertEquals((Object)new DescribeCellsResponseData().setCells(expectedCells).setCellsEnabled(true), (Object)response);
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2, 3, 4, 5), false).value().get();
        this.physicalCluster.superConfluentAdmin().deleteCell(0).value().get();
        expectedCells = Collections.emptyList();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        Assertions.assertEquals(expectedCells, (Object)cells);
        AdminClient tenant0 = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        TestUtils.assertFutureThrows(ResourceNotFoundException.class, (Future)tenant0.createTopics(Collections.singletonList(new NewTopic("topic_1", 1, 3))).all());
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INITIATED).value().get();
        String migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
        tenant0.createTopics(Collections.singletonList(new NewTopic("topic_1", 1, 3))).all().get();
        List tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenantDescriptions = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(-1)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        this.physicalCluster.superConfluentAdmin().createCell(0, CellState.READY).value().get();
        response = (DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get();
        expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.emptyList()).setOpenForTenantAssignment(false).setState(CellState.READY.code()), new DescribeCellsResponseData.Cell().setCellId(-1).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()));
        Assertions.assertEquals(expectedCells, (Object)response.cells());
        AdminClient tenant1 = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        tenant1.createTopics(Collections.singletonList(new NewTopic("topic_2", 1, 3))).all().get();
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        expectedTenantDescriptions = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(-1)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(-1)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        this.physicalCluster.superConfluentAdmin().assignBrokersToCell(Arrays.asList(0, 1, 2, 3, 4, 5), 0, false).value().get();
        response = (DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get();
        expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)).setOpenForTenantAssignment(true).setState(CellState.READY.code()));
        Assertions.assertEquals(expectedCells, (Object)response.cells());
        tenant0.createTopics(Collections.singletonList(new NewTopic("topic_3", 1, 3))).all().get();
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        expectedTenantDescriptions = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(-1)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        this.physicalCluster.superConfluentAdmin().assignTenantsToCells(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Collections.singletonList(0)))).value().get();
        tenantDescriptions = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        expectedTenantDescriptions = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setCellIds(Arrays.asList(0)).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenantDescriptions, (Object)tenantDescriptions);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INACTIVE).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
    }
}

