/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.Assertions;

public class TenantMetricsTestUtils {
    public static final String ACTIVE_AUTH_CONNECTIONS_BY_IP_METRIC_NAME = "active-authenticated-connection-by-ip-count";
    public static final String AUTH_RATE_BY_IP_METRIC_NAME = "successful-authentication-by-ip-rate";
    public static final String AUTH_TOTAL_BY_IP_METRIC_NAME = "successful-authentication-by-ip-total";
    public static final String ACTIVE_AUTH_CONNECTIONS_COUNT_METRIC_NAME = "active-authenticated-connection-count";
    public static final String FAILED_AUTHS_BY_IP_METRIC_NAME = "failed-authentication-by-ip-total";
    public static final String FAILED_AUTH_RATE_BY_IP_METRIC_NAME = "failed-authentication-by-ip-rate";
    public static final String REQUEST_TAG = "request";
    public static final String REQUEST_RATE = "request-rate";
    public static final String REQUEST_TOTAL = "request-total";
    public static final String REQUEST_BYTE_TOTAL = "request-byte-total";
    public static final String REQUEST_BYTE_RATE = "request-byte-rate";
    public static final String REQUEST_BYTE_AVG = "request-byte-avg";
    public static final String REQUEST_BYTE_MIN = "request-byte-min";
    public static final String REQUEST_BYTE_MAX = "request-byte-max";
    public static final String RESPONSE_TIME_NS_MAX = "response-time-ns-max";
    public static final String RESPONSE_TIME_NS_MIN = "response-time-ns-min";
    public static final String RESPONSE_TIME_NS_AVG = "response-time-ns-avg";
    public static final String RESPONSE_BYTE_RATE = "response-byte-rate";
    public static final String RESPONSE_BYTE_TOTAL = "response-byte-total";
    public static final String RESPONSE_BYTE_AVG = "response-byte-avg";
    public static final String RESPONSE_BYTE_MIN = "response-byte-min";
    public static final String RESPONSE_BYTE_MAX = "response-byte-max";
    public static final String[] TENANT_CONNECTION_METRICS = new String[]{"successful-authentication-rate", "successful-authentication-total", "active-authenticated-connection-count"};
    public static final String[] IP_CONNECTION_METRICS = new String[]{"successful-authentication-by-ip-rate", "successful-authentication-by-ip-total", "active-authenticated-connection-by-ip-count"};
    public static final String[] IP_FAILED_AUTHENTICATION_METRICS = new String[]{"failed-authentication-by-ip-total", "failed-authentication-by-ip-rate"};
    public static final String[] REQUEST_METRICS = new String[]{"request-total", "request-byte-total"};
    public static final String[] RESPONSE_METRICS = new String[]{"response-byte-total"};
    public static final String[] RESPONSE_TIME_METRICS = new String[]{"response-time-ns-max", "response-time-ns-avg", "response-time-ns-min"};
    private Metrics metrics;

    public TenantMetricsTestUtils(Metrics metrics) {
        this.metrics = metrics;
    }

    public Map<String, KafkaMetric> verifyTenantMetrics(MetricsBuilderContext context, String ... expectedMetrics) {
        return TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, context, expectedMetrics);
    }

    public static Map<String, KafkaMetric> verifyTenantMetrics(Metrics metrics, MetricsBuilderContext context, String ... expectedMetrics) {
        return TenantMetricsTestUtils.verifyTenantMetrics(metrics, context, false, expectedMetrics);
    }

    public static Map<String, KafkaMetric> verifyTenantMetrics(Metrics metrics, MetricsBuilderContext context, boolean assertZero, String ... expectedMetrics) {
        TenantMetricsTestUtils.verifySensors(metrics, context.sensorSuffix(), expectedMetrics);
        List<String> expectedMetricsList = Arrays.asList(expectedMetrics);
        return TenantMetricsTestUtils.verifyMetrics(metrics, (Map<String, String>)context.metricTags(), assertZero, expectedMetricsList);
    }

    public static Map<String, KafkaMetric> verifyMetrics(Metrics metrics, Map<String, String> tags, boolean assertZero, List<String> expectedMetricsList) {
        return TenantMetricsTestUtils.verifyMetrics(metrics, tags, assertZero, expectedMetricsList, true);
    }

    public static Map<String, KafkaMetric> verifyMetrics(Metrics metrics, Map<String, String> tags, List<String> expectedMetricsList, boolean shouldExist) {
        return TenantMetricsTestUtils.verifyMetrics(metrics, tags, true, expectedMetricsList, shouldExist);
    }

    public static Map<String, KafkaMetric> verifyMetrics(Metrics metrics, Map<String, String> tags, boolean assertZero, List<String> expectedMetricsList, boolean shouldExist) {
        HashMap<String, KafkaMetric> metricsByName = new HashMap<String, KafkaMetric>();
        for (Map.Entry entry : metrics.metrics().entrySet()) {
            MetricName metricName = (MetricName)entry.getKey();
            if (!expectedMetricsList.contains(metricName.name()) || !tags.equals(metricName.tags())) continue;
            KafkaMetric metric = (KafkaMetric)entry.getValue();
            metricsByName.put(metricName.name(), metric);
            double value = (Double)metric.metricValue();
            if (assertZero) {
                Assertions.assertEquals((double)(Double.isNaN(value) ? Double.NaN : 0.0), (double)value, (double)0.0, (String)String.format("Metric (%s) was recorded: %s", metricName, value));
                continue;
            }
            Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)String.format("Metric (%s) not recorded: %s", metricName, value));
        }
        Assertions.assertTrue((boolean)(shouldExist ? metricsByName.size() > 0 : metricsByName.isEmpty()));
        return metricsByName;
    }

    public KafkaMetric metric(String wantedMetricName) {
        return this.metric(this.metrics, wantedMetricName);
    }

    public KafkaMetric metric(Metrics metrics, String wantedMetricName) {
        for (Map.Entry entry : metrics.metrics().entrySet()) {
            MetricName metricName = (MetricName)entry.getKey();
            if (!wantedMetricName.equals(metricName.name())) continue;
            return (KafkaMetric)entry.getValue();
        }
        return null;
    }

    public void verifyActiveTenantIpConnectionsMetrics(Map<MetricsBuilderContext, Double> expectedAuthCountMetricValues) {
        expectedAuthCountMetricValues.forEach((ctx, expected) -> {
            Map<String, KafkaMetric> tenantMetrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, ctx, expected == 0.0, IP_CONNECTION_METRICS);
            Assertions.assertEquals((double)expected, (double)((Double)tenantMetrics.get(ACTIVE_AUTH_CONNECTIONS_BY_IP_METRIC_NAME).metricValue()), (double)0.0);
        });
    }

    public void verifyActiveTenantConnectionsMetrics(Map<MetricsBuilderContext, Double> expectedAuthCountMetricValues) {
        expectedAuthCountMetricValues.forEach((ctx, expected) -> {
            Map<String, KafkaMetric> tenantMetrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, ctx, expected == 0.0, TENANT_CONNECTION_METRICS);
            Assertions.assertEquals((double)expected, (double)((Double)tenantMetrics.get(ACTIVE_AUTH_CONNECTIONS_COUNT_METRIC_NAME).metricValue()), (double)0.0);
        });
    }

    public static void verifySensors(Metrics metrics, String sensorSuffix, String ... expectedMetrics) {
        for (String metricName : expectedMetrics) {
            Sensor sensor = TenantMetricsTestUtils.sensorForMetric(metrics, sensorSuffix, metricName);
            Assertions.assertNotNull((Object)sensor, (String)("Sensor not found for metric " + metricName));
        }
    }

    public static Sensor sensorForMetric(Metrics metrics, String sensorSuffix, String expectedMetric) {
        String name = expectedMetric.substring(0, expectedMetric.lastIndexOf(45));
        String sensorName = name + sensorSuffix;
        return metrics.getSensor(sensorName);
    }
}

