/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.ssl;

import io.confluent.kafka.server.plugins.ssl.ConfluentTrustManagerTest;
import io.confluent.kafka.server.plugins.ssl.NetworkLinkTrustManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NetworkLinkTrustManagerTest
extends ConfluentTrustManagerTest {
    private String brokerSessionUuid;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.brokerSessionUuid = Uuid.randomUuid().toString();
        super.setUp();
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuid, (TrafficNetworkIdRoutes)new TrafficNetworkIdRoutes(Arrays.asList("n1"), null));
    }

    @Override
    protected void createTrustManager() {
        this.brokerConfigs.put("broker.session.uuid", this.brokerSessionUuid);
        this.trustManager = new NetworkLinkTrustManager(this.brokerConfigs, null);
    }

    @Test
    public void testAllowedDNSDomainSuffix() throws Exception {
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuid, (TrafficNetworkIdRoutes)new TrafficNetworkIdRoutes(Arrays.asList("n1, n2"), null));
        Assertions.assertTrue((boolean)this.trustManager.verifyClientCerts(new X509Certificate[]{this.buildCert("*.us-west-2.aws.confluent.cloud", SUBJECT_ALT_DNS_NAMES)}));
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuid, (TrafficNetworkIdRoutes)new TrafficNetworkIdRoutes(Arrays.asList("n1, n2"), Arrays.asList("us-west-1.aws.devel.cpdev.cloud", "us-east-1.aws.devel.cpdev.cloud")));
        Assertions.assertTrue((boolean)this.trustManager.verifyClientCerts(new X509Certificate[]{this.buildCert("*.us-west-2.aws.confluent.cloud", SUBJECT_ALT_DNS_NAMES)}));
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuid, (TrafficNetworkIdRoutes)new TrafficNetworkIdRoutes(Arrays.asList("n1, n2"), Arrays.asList("us-west-1.aws.devel.cpdev.cloud", "us-west-2.aws.devel.cpdev.cloud")));
        Assertions.assertTrue((boolean)this.trustManager.verifyClientCerts(new X509Certificate[]{this.buildCert("*.us-west-2.aws.confluent.cloud", SUBJECT_ALT_DNS_NAMES)}));
    }

    @Test
    public void testDisallowedDNSDomainSuffix() throws Exception {
        TrafficNetworkIdRoutesStore.removeRoutes((String)this.brokerSessionUuid);
        this.verifyCertsNoRoutes(new X509Certificate[]{this.buildCert("*.us-west-2.aws.confluent.cloud", SUBJECT_ALT_DNS_NAMES)});
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuid, (TrafficNetworkIdRoutes)new TrafficNetworkIdRoutes(Arrays.asList(new String[0]), Arrays.asList(new String[0])));
        this.verifyCertsFailure(new X509Certificate[]{this.buildCert("*.us-west-2.aws.confluent.cloud", SUBJECT_ALT_DNS_NAMES)});
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuid, (TrafficNetworkIdRoutes)new TrafficNetworkIdRoutes(Arrays.asList("n1"), Arrays.asList("us-east-1.aws.devel.cpdev.cloud")));
        this.verifyCertsFailure(new X509Certificate[]{this.buildCert("*.us-west-2.aws.confluent.cloud", SUBJECT_ALT_DNS_NAMES)});
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuid, (TrafficNetworkIdRoutes)new TrafficNetworkIdRoutes(Arrays.asList("n1, n2"), Arrays.asList("us-east-2.aws.devel.cpdev.cloud")));
        this.verifyCertsFailure(new X509Certificate[]{this.buildCert("*.us-west-2.aws.confluent.cloud", SUBJECT_ALT_DNS_NAMES)});
    }

    private void verifyCertsNoRoutes(X509Certificate[] certs) {
        CertificateException ce = (CertificateException)Assertions.assertThrows(CertificateException.class, () -> this.trustManager.verifyClientCerts(certs));
        Assertions.assertEquals((Object)"Traffic network routes are not available", (Object)ce.getMessage());
    }
}

