/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.test.utils;

import io.confluent.kafka.test.utils.ClientSecuritySpec;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.tools.AclCommand;

public class AclCommandBuilder {
    private ClientSecuritySpec clientSecuritySpec;
    private List<String> commandArguments;

    public AclCommandBuilder setClientSecuritySpec(ClientSecuritySpec clientSecuritySpec) {
        this.clientSecuritySpec = clientSecuritySpec;
        return this;
    }

    public AclCommandBuilder clusterAclArgs(KafkaPrincipal principal, String op) {
        this.commandArguments = Arrays.asList("--add", "--cluster", "--operation=" + op, "--allow-principal=" + String.valueOf(principal));
        return this;
    }

    public AclCommandBuilder topicBrokerReadAclArgs(KafkaPrincipal principal) {
        this.commandArguments = Arrays.asList("--add", "--topic=*", "--operation=Read", "--allow-principal=" + String.valueOf(principal));
        return this;
    }

    public AclCommandBuilder produceAclArgs(KafkaPrincipal principal, String topic, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--topic=" + topic, "--producer", "--allow-principal=" + String.valueOf(principal));
        return this;
    }

    public AclCommandBuilder consumeAclArgs(KafkaPrincipal principal, String topic, String consumerGroup, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--topic=" + topic, "--group=" + consumerGroup, "--consumer", "--allow-principal=" + String.valueOf(principal));
        return this;
    }

    public AclCommandBuilder addConsumerGroupAclArgs(KafkaPrincipal principal, String consumerGroup, AclOperation op, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--group=" + consumerGroup, "--operation=" + SecurityUtils.operationName((AclOperation)op), "--allow-principal=" + String.valueOf(principal));
        return this;
    }

    public AclCommandBuilder addTopicAclArgs(KafkaPrincipal principal, String topic, AclOperation op, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--topic=" + topic, "--operation=" + SecurityUtils.operationName((AclOperation)op), "--allow-principal=" + String.valueOf(principal));
        return this;
    }

    public AclCommandBuilder addTopicDenyAclArgs(KafkaPrincipal principal, String topic, AclOperation op, PatternType patternType) {
        this.commandArguments = Arrays.asList("--add", "--resource-pattern-type=" + patternType.name(), "--topic=" + topic, "--operation=" + SecurityUtils.operationName((AclOperation)op), "--deny-principal=" + String.valueOf(principal));
        return this;
    }

    public AclCommandBuilder customCommand(List<String> commandArguments) {
        this.commandArguments = commandArguments;
        return this;
    }

    public AclCommandBuilder deleteTopicAclArgs(KafkaPrincipal principal, String topic, String op) {
        this.commandArguments = Arrays.asList("--remove", "--force", "--topic=" + topic, "--operation=" + op, "--allow-principal=" + String.valueOf(principal));
        return this;
    }

    public AclCommandBuilder addLicenseTopicAcl(KafkaPrincipal principal) {
        this.commandArguments = Arrays.asList("--add", "--topic=_confluent-command", "--operation=All", "--allow-principal=" + String.valueOf(principal));
        return this;
    }

    public List<String> arguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.clientSecuritySpec == null) {
            throw new IllegalStateException("AclCommand has not been configured to connect with Zookeeper or Admin");
        }
        String commandConfigFilePath = this.clientSecuritySpec.writePropertiesAsTempFile();
        arguments.add("--bootstrap-server");
        arguments.add(this.clientSecuritySpec.bootstrapServers);
        arguments.add("--command-config");
        arguments.add(commandConfigFilePath);
        arguments.addAll(this.commandArguments);
        return arguments;
    }

    public void execute() {
        AclCommand.main((String[])this.arguments().toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeAndGrabOutput() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buf);
        PrintStream out0 = System.out;
        System.setOut(out);
        try {
            AclCommand.main((String[])this.arguments().toArray(new String[0]));
        }
        finally {
            System.setOut(out0);
        }
        out.flush();
        return buf.toString();
    }
}

