/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver;

import io.confluent.security.auth.oauth.mockserver.common.HttpConnectionException;
import io.confluent.security.auth.oauth.mockserver.common.SupportedAlgorithms;
import io.confluent.security.auth.oauth.mockserver.server.CommonHttp;
import io.confluent.security.auth.oauth.mockserver.server.MockOAuthServer;
import io.confluent.security.auth.oauth.mockserver.server.TokenBuilder;
import io.confluent.security.auth.oauth.mockserver.server.URLEndpoints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockOAuthTests {
    private static final Logger log = LoggerFactory.getLogger(MockOAuthTests.class);
    MockOAuthServer mockOAuthServer;
    private static final String CLIENT_ID = "testClientID";
    private static final String CLIENT_SECRET = "testClientSecret";
    private static final int EXPIRY = 12;
    private static final String SUBJECT = "testSubject";
    private static final String AUDIENCE = "Aud1";
    private static final String ISSUER = "defaultIssuer";
    private static final String CLAIMS_KEY = "Claim";
    private static final String CLAIMS_VALUE = "Value";
    private static final String CLAIM_CLUSTERS = "clusters";
    private static final List<String> CLAIM_CLUSTERS_VALUE = new ArrayList<String>(Collections.singleton("LKC_XYZ"));
    private static final SupportedAlgorithms ALGORITHM = SupportedAlgorithms.RS256;
    private static final int AUTH_SERVER_PORT = 62345;

    @BeforeEach
    public void init() {
        try {
            this.mockOAuthServer = new MockOAuthServer();
            this.mockOAuthServer.startServer(62345);
            this.mockOAuthServer.connectToServer();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            Assertions.fail();
        }
    }

    @AfterEach
    public void Teardown() {
        this.mockOAuthServer.stopServer();
    }

    @Test
    public void testGetJWKS() {
        try {
            String jwk = CommonHttp.sendGET(URLEndpoints.getJwksURL(this.mockOAuthServer.getAuthServerPort()));
            Assertions.assertTrue((boolean)jwk.contains("\"kid\":\"Confluent\""));
            Assertions.assertTrue((boolean)jwk.contains("\"use\":\"sig\""));
        }
        catch (HttpConnectionException | IOException e) {
            log.error("Failed due to: " + e.getMessage());
            Assertions.fail();
        }
    }

    @Test
    public void testGetToken() {
        try {
            String token = new TokenBuilder(CLIENT_ID, CLIENT_SECRET, this.mockOAuthServer).setExpiry(12).setSubject(SUBJECT).addAudience(AUDIENCE).addClaims(CLAIMS_KEY, CLAIMS_VALUE).setIssuer(ISSUER).addClaims(CLAIM_CLUSTERS, CLAIM_CLUSTERS_VALUE).setAlgo(ALGORITHM).build();
            Assertions.assertNotNull((Object)token);
            String[] tokenComponents = token.split("\\.");
            Assertions.assertEquals((int)3, (int)tokenComponents.length);
            Base64.Decoder decoder = Base64.getUrlDecoder();
            String header = new String(decoder.decode(tokenComponents[0]));
            Assertions.assertTrue((boolean)header.contains("\"kid\":\"defaultIssuer\""));
            Assertions.assertTrue((boolean)header.contains("\"alg\":\"" + String.valueOf(ALGORITHM.getAlgorithm()) + "\""));
            String payload = new String(decoder.decode(tokenComponents[1]));
            Assertions.assertTrue((boolean)payload.contains("\"sub\":\"testSubject\""));
            Assertions.assertTrue((boolean)payload.contains("\"Claim\":\"Value\""));
        }
        catch (IOException e) {
            log.error("Failed due to: " + e.getMessage());
            Assertions.fail();
        }
    }

    @Test
    public void getConfigs() {
        try {
            JSONObject configs = this.mockOAuthServer.getConfig();
            System.out.println("****" + configs.toString());
            Assertions.assertNotNull((Object)configs);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            Assertions.fail();
        }
    }

    @Test
    public void testGetJWKSforNonConfluentIssuer() {
        try {
            new TokenBuilder(CLIENT_ID, CLIENT_SECRET, this.mockOAuthServer).setExpiry(12).setSubject(SUBJECT).addAudience(AUDIENCE).addClaims(CLAIMS_KEY, CLAIMS_VALUE).addClaims(CLAIM_CLUSTERS, CLAIM_CLUSTERS_VALUE).setIssuer(ISSUER).setAlgo(ALGORITHM).build();
            String jwks = CommonHttp.sendGET(URLEndpoints.getJwksURL(this.mockOAuthServer.getAuthServerPort()));
            Assertions.assertTrue((boolean)jwks.contains("\"kid\":\"defaultIssuer\","));
        }
        catch (HttpConnectionException | IOException e) {
            log.error(e.getMessage());
            Assertions.fail();
        }
    }
}

