/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.mtls;

import io.confluent.security.mtls.DefaultMTlsConnectionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kafka.server.BrokerSession;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.security.mtls.MTlsConnectionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DefaultMTlsConnectionManagerTest {
    private static final String TEST_BROKER_SESSION_UUID = "broker-session-uuid";
    private Consumer<PublicCredential> credentialDeleteListener;
    private KafkaConfig kafkaConfig;
    private Map<String, Object> configs;

    DefaultMTlsConnectionManagerTest() {
    }

    @BeforeEach
    void setUp() {
        this.credentialDeleteListener = (Consumer)Mockito.mock(Consumer.class);
        this.kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)this.kafkaConfig.brokerSessionUuid()).thenReturn((Object)TEST_BROKER_SESSION_UUID);
        this.configs = new HashMap<String, Object>();
        this.configs.put("broker.session.uuid", TEST_BROKER_SESSION_UUID);
    }

    @AfterEach
    void tearDown() {
        BrokerSession.closeSession((String)TEST_BROKER_SESSION_UUID);
    }

    @Test
    void testConfigure_with_ConfluentConfigs_buildMTlsConnectionManager_noBrokerSessionUuid_failed() {
        Exception exception = (Exception)Assertions.assertThrows(ConfigException.class, () -> ConfluentConfigs.buildMTlsConnectionManager(new HashMap()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Broker session UUID must be set in the Kafka config!"));
    }

    @Test
    void testConfigure_with_ConfluentConfigs_buildMTlsConnectionManager_withBrokerSessionUuid_passes() {
        Assertions.assertInstanceOf(DefaultMTlsConnectionManager.class, (Object)ConfluentConfigs.buildMTlsConnectionManager(this.configs));
    }

    @Test
    void testCloseConnections_nullBrokerSession_doNothing() {
        MTlsConnectionManager mTlsConnectionManager = ConfluentConfigs.buildMTlsConnectionManager(this.configs);
        Assertions.assertInstanceOf(DefaultMTlsConnectionManager.class, (Object)mTlsConnectionManager);
        Assertions.assertNull((Object)((DefaultMTlsConnectionManager)mTlsConnectionManager).getSession());
        mTlsConnectionManager.closeConnections(PublicCredential.mTlsCredential((String)"orgId", (String)"providerId", (String)"issuerDn", (String)"snid"));
        ((Consumer)Mockito.verify(this.credentialDeleteListener, (VerificationMode)Mockito.never())).accept((PublicCredential)ArgumentMatchers.any());
    }

    @Test
    void testCloseConnections_withoutCloseConnectionsOnCredentialDelete_doNothing() {
        BrokerSession.addSession((KafkaConfig)this.kafkaConfig, this.credentialDeleteListener);
        MTlsConnectionManager mTlsConnectionManager = ConfluentConfigs.buildMTlsConnectionManager(this.configs);
        Assertions.assertInstanceOf(DefaultMTlsConnectionManager.class, (Object)mTlsConnectionManager);
        Assertions.assertNotNull((Object)((DefaultMTlsConnectionManager)mTlsConnectionManager).getSession());
        mTlsConnectionManager.closeConnections(PublicCredential.mTlsCredential((String)"orgId", (String)"providerId", (String)"issuerDn", (String)"snid"));
        ((Consumer)Mockito.verify(this.credentialDeleteListener, (VerificationMode)Mockito.never())).accept((PublicCredential)ArgumentMatchers.any());
    }

    @Test
    void testCloseConnections_withCloseConnectionsOnCredentialDelete_callCredentialDeleteListener() {
        Mockito.when((Object)this.kafkaConfig.closeConnectionsOnCredentialDelete()).thenReturn((Object)true);
        BrokerSession.addSession((KafkaConfig)this.kafkaConfig, this.credentialDeleteListener);
        MTlsConnectionManager mTlsConnectionManager = ConfluentConfigs.buildMTlsConnectionManager(this.configs);
        Assertions.assertInstanceOf(DefaultMTlsConnectionManager.class, (Object)mTlsConnectionManager);
        Assertions.assertNotNull((Object)((DefaultMTlsConnectionManager)mTlsConnectionManager).getSession());
        PublicCredential publicCredential = PublicCredential.mTlsCredential((String)"orgId", (String)"providerId", (String)"issuerDn", (String)"snid");
        mTlsConnectionManager.closeConnections(publicCredential);
        ((Consumer)Mockito.verify(this.credentialDeleteListener, (VerificationMode)Mockito.times((int)1))).accept(publicCredential);
    }
}

