/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.server.metrics.AbstractSensorCreator;

public class ApiKeysVersionSensors {
    protected final Sensor sensor;

    public ApiKeysVersionSensors(Sensor sensor) {
        this.sensor = sensor;
    }

    public void recordMaxVersion(int maxVersion) {
        this.sensor.record((double)maxVersion);
    }

    protected static class ApiKeysVersionSensorCreator
    extends AbstractSensorCreator {
        static final long EXPIRY_SECONDS = TimeUnit.DAYS.toSeconds(4L);

        ApiKeysVersionSensorCreator(String name, String descriptiveName) {
            super(name, descriptiveName);
        }

        Sensor createSensor(Metrics metrics, String sensorName, TenantMetrics.ApiKeysVersionContext context) {
            Sensor sensor = super.createSensor(metrics, sensorName, EXPIRY_SECONDS);
            Map<String, String> metricTags = context.metricTags();
            String group = context.metricsGroup();
            sensor.add(metrics.metricName(this.name + "-min", group, "The minimum value seen for " + this.descriptiveName, metricTags), (MeasurableStat)new Min());
            return sensor;
        }
    }
}

