/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.server.metrics.utils.MetricUtils;
import org.apache.kafka.server.quota.SensorAccess;

public class DeprecatedRequestSensors {
    private static final String DEPRECATED_REQUEST_NAME = "deprecated-request";
    private static final String UNIQUE_DEPRECATED_REQUEST_METRICS_NAME = "unique-deprecated-request-metrics";
    private static final long DEPRECATED_REQUEST_EXPIRY_TIME_MS = TimeUnit.MINUTES.toMillis(2L);
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private final Metrics metrics;
    private final SensorAccess sensorAccess;
    private final String deprecatedRequestSensorName;
    private final Consumer<Sensor> registerDeprecatedRequestMetric;
    private final Sensor uniqueDeprecatedRequestMetricsSensor;
    private final Consumer<Sensor> onDeprecatedRequestMetricExpiration;

    public DeprecatedRequestSensors(Metrics metrics, MultiTenantPrincipal principal, ApiKeys apiKey, String clientId, int maxDeprecatedRequestMetricsPerTenant) {
        this.metrics = metrics;
        this.sensorAccess = new SensorAccess(LOCK, metrics);
        Map<String, String> deprecatedRequestTags = this.deprecatedRequestTags(principal, apiKey, clientId);
        MetricName deprecatedRequestMetricName = MetricUtils.totalMetricName((Metrics)metrics, (String)"tenant-metrics", deprecatedRequestTags, (String)DEPRECATED_REQUEST_NAME, (String)DEPRECATED_REQUEST_NAME);
        this.deprecatedRequestSensorName = DEPRECATED_REQUEST_NAME + MetricUtils.tagsToSensorSuffix(deprecatedRequestTags);
        this.registerDeprecatedRequestMetric = sensor -> sensor.add(deprecatedRequestMetricName, (MeasurableStat)new CumulativeSum());
        this.uniqueDeprecatedRequestMetricsSensor = this.createUniqueDeprecatedRequestMetricsSensor(principal, maxDeprecatedRequestMetricsPerTenant);
        this.onDeprecatedRequestMetricExpiration = sensor -> this.uniqueDeprecatedRequestMetricsSensor.record(-1.0, false);
    }

    public void recordDeprecatedRequest() {
        this.sensorAccess.mayGetOrCreate(this.deprecatedRequestSensorName, DEPRECATED_REQUEST_EXPIRY_TIME_MS, Optional.empty(), this.registerDeprecatedRequestMetric, this::mayRecordToUniqueDeprecatedRequestMetricsSensor, this.onDeprecatedRequestMetricExpiration).ifPresent(Sensor::record);
    }

    private Map<String, String> deprecatedRequestTags(MultiTenantPrincipal principal, ApiKeys apiKey, String clientId) {
        LinkedHashMap<String, String> deprecatedRequestTags = new LinkedHashMap<String, String>();
        deprecatedRequestTags.put("io-confluent-jmx-ignore", "");
        deprecatedRequestTags.put("request", apiKey.name);
        deprecatedRequestTags.put("tenant", principal.tenantMetadata().tenantName);
        if (principal.tenantMetadata().userResourceId != null) {
            deprecatedRequestTags.put("user-resource-id", principal.tenantMetadata().userResourceId);
        }
        deprecatedRequestTags.put("client-id", clientId);
        return Collections.unmodifiableMap(deprecatedRequestTags);
    }

    private Sensor createUniqueDeprecatedRequestMetricsSensor(MultiTenantPrincipal principal, int maxDeprecatedRequestMetricsPerTenant) {
        LinkedHashMap<String, String> uniqueDeprecatedRequestMetricsTags = new LinkedHashMap<String, String>();
        uniqueDeprecatedRequestMetricsTags.put("io-confluent-jmx-ignore", "");
        uniqueDeprecatedRequestMetricsTags.put("tenant", principal.tenantMetadata().tenantName);
        MetricName uniqueDeprecatedRequestMetricsMetricName = this.metrics.metricName(UNIQUE_DEPRECATED_REQUEST_METRICS_NAME, "tenant-metrics", uniqueDeprecatedRequestMetricsTags);
        MetricConfig uniqueDeprecatedRequestMetricsMetricConfig = new MetricConfig().quota(Quota.upperBound((double)maxDeprecatedRequestMetricsPerTenant));
        String uniqueDeprecatedRequestMetricsSensorName = UNIQUE_DEPRECATED_REQUEST_METRICS_NAME + MetricUtils.tagsToSensorSuffix(uniqueDeprecatedRequestMetricsTags);
        return this.sensorAccess.getOrCreate(uniqueDeprecatedRequestMetricsSensorName, Long.MAX_VALUE, sensor -> sensor.add(uniqueDeprecatedRequestMetricsMetricName, (MeasurableStat)new CumulativeSum(), uniqueDeprecatedRequestMetricsMetricConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mayRecordToUniqueDeprecatedRequestMetricsSensor() {
        Sensor sensor = this.uniqueDeprecatedRequestMetricsSensor;
        synchronized (sensor) {
            this.uniqueDeprecatedRequestMetricsSensor.record(1.0, false);
            if (!this.uniqueDeprecatedRequestMetricsSensor.getQuotaViolations(false).isEmpty()) {
                this.uniqueDeprecatedRequestMetricsSensor.record(-1.0, false);
                return false;
            }
            return true;
        }
    }
}

