/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.HotPartitionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.HotPartitionSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.metrics.utils.MetricSampler;
import io.confluent.kafka.multitenant.metrics.utils.PartitionMetricUtils;
import io.confluent.kafka.multitenant.metrics.utils.TimeIntervalMetricSampler;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.server.QuotaFactory;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.utils.MetricUtils;
import org.apache.kafka.server.quota.ClientQuotaType;

public class HotPartitionManager
implements Configurable {
    private static final long SAMPLE_INTERVAL_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private final MetricSampler ingressMetricSampler;
    private final MetricSampler egressMetricSampler;
    private boolean hotPartitionMetricEnabled;
    private long defaultBrokerLimitProducerBytesPerSecond;
    private long defaultBrokerLimitConsumerBytesPerSecond;
    private double hotPartitionRatio;
    private HotPartitionSensors hotPartitionSensors;

    public HotPartitionManager(Time time) {
        this.ingressMetricSampler = new TimeIntervalMetricSampler(time, SAMPLE_INTERVAL_NANOS);
        this.egressMetricSampler = new TimeIntervalMetricSampler(time, SAMPLE_INTERVAL_NANOS);
    }

    HotPartitionManager(MetricSampler ingressMetricSampler, MetricSampler egressMetricSampler) {
        this.ingressMetricSampler = ingressMetricSampler;
        this.egressMetricSampler = egressMetricSampler;
    }

    public void configure(Map<String, ?> configs) {
        this.defaultBrokerLimitProducerBytesPerSecond = HotPartitionManager.brokerLimitProducerBytesPerSecond(configs);
        this.defaultBrokerLimitConsumerBytesPerSecond = HotPartitionManager.brokerLimitConsumerBytesPerSecond(configs);
        this.hotPartitionRatio = HotPartitionManager.hotPartitionRatio(configs);
        this.hotPartitionMetricEnabled = this.isHotPartitionMetricEnabled(this.hotPartitionRatio);
    }

    private static long brokerLimitProducerBytesPerSecond(Map<String, ?> configs) {
        Long brokerLimitProducerBytesPerSecond = (Long)configs.get("confluent.broker.limit.producer.bytes.per.second");
        return brokerLimitProducerBytesPerSecond == null ? ConfluentConfigs.BROKER_LIMIT_PRODUCER_DEFAULT : brokerLimitProducerBytesPerSecond;
    }

    private static long brokerLimitConsumerBytesPerSecond(Map<String, ?> configs) {
        Long brokerLimitConsumerBytesPerSecond = (Long)configs.get("confluent.broker.limit.consumer.bytes.per.second");
        return brokerLimitConsumerBytesPerSecond == null ? ConfluentConfigs.BROKER_LIMIT_CONSUMER_DEFAULT : brokerLimitConsumerBytesPerSecond;
    }

    private static double hotPartitionRatio(Map<String, ?> configs) {
        Double hotPartitionRatio = (Double)configs.get("confluent.hot.partition.ratio");
        return hotPartitionRatio == null ? 0.8 : hotPartitionRatio;
    }

    public void mayRecordHotPartitionIn(Metrics metrics, TenantMetrics.TenantMetricsContext context, TopicPartition tp, long timeMs) {
        MetricName produceRateMetricName;
        KafkaMetric produceRateMetric;
        if (this.hotPartitionMetricEnabled && this.ingressMetricSampler.shouldSample() && (produceRateMetric = metrics.metric(produceRateMetricName = MetricUtils.rateMetricName((Metrics)metrics, (String)"tenant-metrics", this.partitionBytesRateMetricTags(context, tp), (String)"partition-bytes-in", (String)"partition-bytes-in"))) != null && this.isHotPartitionIn(produceRateMetric.measurableValue(timeMs))) {
            this.hotPartitionSensors(metrics, context).recordHotPartitionIn(tp, timeMs);
        }
    }

    public void mayRecordHotPartitionOut(Metrics metrics, TenantMetrics.MetricsRequestContext context, TopicPartition tp, long timeMs) {
        MetricName fetchRateMetricName;
        KafkaMetric fetchRateMetric;
        if (this.hotPartitionMetricEnabled && this.egressMetricSampler.shouldSample() && (fetchRateMetric = metrics.metric(fetchRateMetricName = MetricUtils.rateMetricName((Metrics)metrics, (String)"tenant-metrics", this.partitionBytesRateMetricTags(context, tp), (String)"partition-bytes-out", (String)"partition-bytes-out"))) != null && this.isHotPartitionOut(fetchRateMetric.measurableValue(timeMs))) {
            this.hotPartitionSensors(metrics, context).recordHotPartitionOut(tp, timeMs);
        }
    }

    private boolean isHotPartitionMetricEnabled(double hotPartitionRatio) {
        return hotPartitionRatio > 0.0;
    }

    private boolean isHotPartitionIn(double produceBytesPerSecond) {
        return produceBytesPerSecond >= QuotaFactory.QuotaManagers.getBrokerQuotaLimitByTypeOrElse((ClientQuotaType)ClientQuotaType.PRODUCE, (double)this.defaultBrokerLimitProducerBytesPerSecond) * this.hotPartitionRatio;
    }

    private boolean isHotPartitionOut(double fetchBytesPerSecond) {
        return fetchBytesPerSecond >= QuotaFactory.QuotaManagers.getBrokerQuotaLimitByTypeOrElse((ClientQuotaType)ClientQuotaType.FETCH, (double)this.defaultBrokerLimitConsumerBytesPerSecond) * this.hotPartitionRatio;
    }

    private Map<String, String> partitionBytesRateMetricTags(TenantMetrics.TenantMetricsContext context, TopicPartition tp) {
        String tenant = context.principal().tenantMetadata().tenantName;
        return PartitionMetricUtils.tenantPartitionMetricTags(tenant, tp);
    }

    private HotPartitionSensors hotPartitionSensors(Metrics metrics, TenantMetrics.TenantMetricsContext context) {
        if (this.hotPartitionSensors == null) {
            this.hotPartitionSensors = new HotPartitionSensorBuilder(metrics, context).build();
        }
        return this.hotPartitionSensors;
    }
}

