/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.serde;

import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.kafka.multitenant.serde.EventsMetadataHeader;
import io.confluent.protobuf.cloud.events.v1.EventsMetadata;
import io.confluent.security.auth.store.data.RoleBindingKey;
import io.confluent.security.auth.store.data.RoleBindingValue;
import io.confluent.security.authorizer.utils.JsonMapper;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class RoleBindingMetadataFormatter
implements MessageFormatter {
    private boolean printHeader;
    private boolean printKey;
    private boolean printValue;
    private boolean printTimestamp;
    private boolean printPartition;
    private boolean printOffset;

    public void configure(Map<String, ?> configs) {
        this.printHeader = this.getBoolean(configs, "print.header", Boolean.FALSE);
        this.printKey = this.getBoolean(configs, "print.key", Boolean.FALSE);
        this.printValue = this.getBoolean(configs, "print.value", Boolean.TRUE);
        this.printTimestamp = this.getBoolean(configs, "print.timestamp", Boolean.FALSE);
        this.printPartition = this.getBoolean(configs, "print.partition", Boolean.FALSE);
        this.printOffset = this.getBoolean(configs, "print.offset", Boolean.FALSE);
    }

    private boolean getBoolean(Map<String, ?> configs, String name, boolean defaultValue) {
        return Boolean.parseBoolean(this.getString(configs, name, Boolean.toString(defaultValue)).trim());
    }

    private String getString(Map<String, ?> configs, String name, String defaultValue) {
        Object o = configs.get(name);
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Unexpected type for config value for '" + name + "', expected String but found " + String.valueOf(o.getClass()) + ", value: " + String.valueOf(o));
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (this.printTimestamp) {
            output.append("Timestamp: ").append(Long.toString(consumerRecord.timestamp())).append(" | ");
        }
        if (this.printPartition) {
            output.append("Partition: ").append(Integer.toString(consumerRecord.partition())).append(" | ");
        }
        if (this.printOffset) {
            output.append("Offset: ").append(Long.toString(consumerRecord.offset())).append(" | ");
        }
        if (this.printHeader && consumerRecord.headers() != null) {
            output.append("Header: ").append(this.getEventsMetadataHeader(consumerRecord.headers())).append(" | ");
        }
        if (this.printKey) {
            output.append("Key: ").append(this.getJsonMapperObject(RoleBindingKey.class, (byte[])consumerRecord.key())).append(" | ");
        }
        if (this.printValue) {
            output.append("Value: ").append(this.getJsonMapperObject(RoleBindingValue.class, (byte[])consumerRecord.key())).append(" | ");
        }
        output.append("\n");
    }

    private String getEventsMetadataHeader(Headers headers) {
        Header lastEventsMetadataHeader = headers.lastHeader("eventsmetadata");
        if (lastEventsMetadataHeader != null) {
            try {
                EventsMetadata eventsMetadata = EventsMetadata.parseFrom((byte[])lastEventsMetadataHeader.value());
                EventsMetadataHeader eventsMetadataHeader = EventsMetadataHeader.fromProtobuf(eventsMetadata);
                return eventsMetadataHeader.toString();
            }
            catch (InvalidProtocolBufferException e) {
                return "Unable to parse events metadata header: " + e.getMessage();
            }
        }
        return null;
    }

    private <T> String getJsonMapperObject(Class<T> clazz, byte[] data) {
        try {
            return JsonMapper.objectMapper().readValue(data, clazz).toString();
        }
        catch (IOException e) {
            return "Unable to parse role binding value: " + e.getMessage();
        }
    }

    public void close() {
    }
}

