/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import java.util.Optional;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SniValidationMode {
    OPTIONAL_VALIDATION("optional_validation"){

        @Override
        public boolean sniHostNameMatches(String expectedLogicalClusterId, Optional<String> suppliedClusterId, Optional<PathAwareSniHostName> sniHostName) {
            return !suppliedClusterId.isPresent() || suppliedClusterId.get().equals(expectedLogicalClusterId);
        }
    }
    ,
    ALLOW_LEGACY_BOOTSTRAP("allow_legacy_bootstrap"){

        @Override
        public boolean sniHostNameMatches(String expectedLogicalClusterId, Optional<String> suppliedClusterId, Optional<PathAwareSniHostName> sniHostName) {
            if (STRICT.sniHostNameMatches(expectedLogicalClusterId, suppliedClusterId, sniHostName)) {
                return true;
            }
            return sniHostName.isPresent() && sniHostName.get().strippedHostname().startsWith("pkc-");
        }
    }
    ,
    STRICT("strict"){

        @Override
        public boolean sniHostNameMatches(String expectedLogicalClusterId, Optional<String> suppliedClusterId, Optional<PathAwareSniHostName> sniHostName) {
            return suppliedClusterId.isPresent() && suppliedClusterId.get().equals(expectedLogicalClusterId);
        }
    };

    public static final String SNI_HOST_NAME_VALIDATION_MODE_KEY = "sni_host_name_validation_mode";
    private static final Logger log;
    private final String text;

    private SniValidationMode(String mode) {
        this.text = mode;
    }

    public static SniValidationMode fromString(String text) {
        for (SniValidationMode mode : SniValidationMode.values()) {
            if (!mode.getText().equals(text)) continue;
            return mode;
        }
        log.debug("Unknown SNI validation mode: {}. Set it to optional_validation", (Object)text);
        return OPTIONAL_VALIDATION;
    }

    public String getText() {
        return this.text;
    }

    public abstract boolean sniHostNameMatches(String var1, Optional<String> var2, Optional<PathAwareSniHostName> var3);

    static {
        log = LoggerFactory.getLogger(SniValidationMode.class);
    }
}

