/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.roledefinitions;

import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.BindingScopes;
import io.confluent.security.roledefinitions.InvalidRoleDefinitionException;
import io.confluent.security.roledefinitions.RbacRoles;
import io.confluent.security.roledefinitions.Role;
import io.confluent.security.roledefinitions.RolePermissionsFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RbacResourcesLoader {
    public static RbacRoles loadFilteredRoles(String filterName) {
        RolePermissionsFilter rolePermissionsFilter = RbacResourcesLoader.getRolePermissionsFilterByFilterName(filterName);
        RbacRoles reducedRoles = RbacResourcesLoader.filterRoles(rolePermissionsFilter);
        return RbacResourcesLoader.filterAccessPolicies(reducedRoles, rolePermissionsFilter);
    }

    private static RolePermissionsFilter getRolePermissionsFilterByFilterName(String filterName) {
        RolePermissionsFilter rolePermissionsFilter;
        BufferedReader reader = new BufferedReader(new InputStreamReader(RbacResourcesLoader.class.getClassLoader().getResourceAsStream("role-permission-filters/" + filterName + ".yaml"), StandardCharsets.UTF_8));
        try {
            rolePermissionsFilter = (RolePermissionsFilter)RbacRoles.yamlObjectMapper().readValue((Reader)reader, RolePermissionsFilter.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading filter file: " + filterName, e);
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Filter not found: " + filterName, e);
            }
        }
        reader.close();
        return rolePermissionsFilter;
    }

    private static RbacRoles filterRoles(RolePermissionsFilter rolePermissionsFilter) {
        List<String> filteredRoleNames = rolePermissionsFilter.getRolesInFilter().stream().map(roleName -> roleName + ".yaml").collect(Collectors.toList());
        return RbacRoles.mergedRbacRoles(RbacResourcesLoader.class.getClassLoader(), filteredRoleNames);
    }

    private static RbacRoles filterAccessPolicies(RbacRoles roles, RolePermissionsFilter rolePermissionsFilter) {
        RbacRoles filteredRoles = new RbacRoles(new ArrayList<Role>(), roles.bindingScopes());
        for (Role role : roles.roles()) {
            ArrayList<AccessPolicy> filteredAccessPolicies = rolePermissionsFilter.filter(role);
            if (filteredAccessPolicies.isEmpty()) {
                throw new InvalidRoleDefinitionException("Role " + role.name() + " has no allowed operations for the given filter.");
            }
            filteredRoles.addRole(new Role(role.name(), role.displayName(), role.namespace(), role.internal(), role.rbacQuota(), null, filteredAccessPolicies));
        }
        return filteredRoles;
    }

    @VisibleForTesting
    public static RbacRoles test_loadFilteredRoles(String filterName) {
        RolePermissionsFilter rolePermissionsFilter = RbacResourcesLoader.test_getRolePermissionsFilter(filterName);
        RbacRoles reducedRoles = RbacResourcesLoader.filterRoles(rolePermissionsFilter);
        return RbacResourcesLoader.filterAccessPolicies(reducedRoles, rolePermissionsFilter);
    }

    @VisibleForTesting
    public static RbacRoles test_loadTestingRoles(List<String> policyResourceNames) {
        return RbacResourcesLoader.test_mergedRbacRoles(policyResourceNames);
    }

    private static RolePermissionsFilter test_getRolePermissionsFilter(String filterName) {
        RolePermissionsFilter rolePermissionsFilter;
        BufferedReader reader = new BufferedReader(new InputStreamReader(RbacResourcesLoader.class.getClassLoader().getResourceAsStream("test-role-permission-filters/" + filterName + ".yaml"), StandardCharsets.UTF_8));
        try {
            rolePermissionsFilter = (RolePermissionsFilter)RbacRoles.yamlObjectMapper().readValue((Reader)reader, RolePermissionsFilter.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidRoleDefinitionException("Filter not found: " + filterName, e);
            }
        }
        reader.close();
        return rolePermissionsFilter;
    }

    private static RbacRoles test_mergedRbacRoles(List<String> policyResourceNames) {
        List rbacRoles = policyResourceNames.stream().map(RbacResourcesLoader::test_parseRbacRoles).collect(Collectors.toList());
        RbacRoles mergedRbacRoles = (RbacRoles)rbacRoles.remove(0);
        for (RbacRoles rbacRole : rbacRoles) {
            mergedRbacRoles = RbacRoles.mergeYaml(mergedRbacRoles, rbacRole);
        }
        return mergedRbacRoles;
    }

    private static RbacRoles test_parseRbacRoles(String policyResourceName) {
        RbacRoles rbacRoles;
        BufferedReader reader = new BufferedReader(new InputStreamReader(RbacResourcesLoader.class.getClassLoader().getResourceAsStream("test-role-definitions/" + policyResourceName), StandardCharsets.UTF_8));
        try {
            Role role = (Role)RbacRoles.yamlObjectMapper().readValue((Reader)reader, Role.class);
            BindingScopes bindingScopes = policyResourceName.startsWith("cp") ? RbacRoles.CP_BINDING_SCOPES : RbacRoles.CLOUD_BINDING_SCOPES;
            rbacRoles = new RbacRoles(new ArrayList<Role>(Collections.singletonList(role)), bindingScopes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidRoleDefinitionException("Could not find test role definition", e);
            }
        }
        reader.close();
        return rbacRoles;
    }

    public static @interface VisibleForTesting {
    }
}

