/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.auth.AutoValue_AuthorizationHeader;
import java.util.Locale;
import java.util.StringTokenizer;

@AutoValue
abstract class AuthorizationHeader {
    AuthorizationHeader() {
    }

    abstract Scheme getScheme();

    abstract String getCredentials();

    static AuthorizationHeader parse(String header) {
        StringTokenizer tokenized = new StringTokenizer(header);
        if (tokenized.countTokens() != 2) {
            throw new IllegalArgumentException("Malformed Authorization header.");
        }
        Scheme scheme = Scheme.valueOf(tokenized.nextToken().toUpperCase(Locale.ROOT));
        String credentials = tokenized.nextToken();
        return new AutoValue_AuthorizationHeader(scheme, credentials);
    }

    static enum Scheme {
        BASIC,
        BEARER;

    }
}

