/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsStore;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.auth.AuthorizationHeader;
import io.confluent.kafkarest.auth.CloudPrincipal;
import io.confluent.kafkarest.auth.CloudSecurityContext;
import io.confluent.rest.entities.ErrorMessage;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public final class CloudExtensionsAuthFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CloudExtensionsAuthFilter.class);
    private static final String API_KEY_CLUSTER_MISMATCH_TMPL = "API key '%s' is not allowed to access provided cluster ID '%s'";
    public static final String REQUIRE_SECRETS_STORE_VALIDATION_CONFIG = "secrets.store.validation.required";
    private final boolean requireSecretsStoreValidation;
    private final MultiTenantSaslSecretsStore secretsStore;

    @Inject
    public CloudExtensionsAuthFilter(Provider<KafkaRestConfig> configProvider, Provider<MultiTenantSaslSecretsStore> secretsStoreProvider) {
        this.requireSecretsStoreValidation = CloudExtensionsAuthFilter.requireSecretsStoreValidation((KafkaRestConfig)configProvider.get());
        this.secretsStore = (MultiTenantSaslSecretsStore)secretsStoreProvider.get();
        if (this.secretsStore == null && this.requireSecretsStoreValidation) {
            log.error("Credentials store not available; validation for API key credentials cannot be performed!");
        }
    }

    @VisibleForTesting
    static boolean requireSecretsStoreValidation(KafkaRestConfig config) {
        boolean requireSecretsStoreValidation = true;
        if (config != null) {
            Object value = config.getOriginalProperties().get(REQUIRE_SECRETS_STORE_VALIDATION_CONFIG);
            if (value instanceof Boolean) {
                requireSecretsStoreValidation = (Boolean)value;
            } else if (value instanceof String) {
                requireSecretsStoreValidation = Boolean.parseBoolean((String)value);
            }
        }
        return requireSecretsStoreValidation;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        CloudPrincipal cloudPrincipal = CloudExtensionsAuthFilter.extractCredentials(requestContext);
        if (cloudPrincipal == null) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            return;
        }
        Response validationErrorResponse = this.validateCredentials(cloudPrincipal);
        if (validationErrorResponse != null) {
            requestContext.abortWith(validationErrorResponse);
            return;
        }
        CloudExtensionsAuthFilter.setSecurityContext(cloudPrincipal, requestContext);
    }

    private static CloudPrincipal extractCredentials(ContainerRequestContext requestContext) {
        try {
            String clusterId = (String)requestContext.getUriInfo().getPathParameters(true).getFirst((Object)"clusterId");
            AuthorizationHeader authorizationHeader = AuthorizationHeader.parse((String)requestContext.getHeaders().getFirst((Object)"Authorization"));
            return CloudPrincipal.create(clusterId, authorizationHeader);
        }
        catch (Exception e) {
            log.debug("Failed to extract credentials from request.");
            return null;
        }
    }

    private Response validateCredentials(CloudPrincipal cloudPrincipal) {
        if (!AuthorizationHeader.Scheme.BASIC.equals((Object)cloudPrincipal.getScheme())) {
            log.debug("Validation for non-API key credentials will be handled as part of authentication.");
            return null;
        }
        if (this.secretsStore == null) {
            log.error("Credentials store not available; validation for API key credentials cannot be performed!");
            return this.requireSecretsStoreValidation ? Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build() : null;
        }
        MultiTenantSaslSecrets secrets = this.secretsStore.load();
        if (secrets == null) {
            log.error("Credential store still unavailable after server initialization!");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        String apiKey = cloudPrincipal.getName();
        MultiTenantSaslConfigEntry userInfo = (MultiTenantSaslConfigEntry)secrets.entries().get(apiKey);
        if (userInfo == null) {
            log.debug("API key '{}' cannot be not found in the credential store", (Object)apiKey);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String providedClusterIdForApiKey = cloudPrincipal.getClusterId();
        String expectedClusterIdForApiKey = userInfo.logicalClusterId();
        if (providedClusterIdForApiKey == null || !providedClusterIdForApiKey.equals(expectedClusterIdForApiKey)) {
            String apiKeyClusterMismatchMessage = String.format(API_KEY_CLUSTER_MISMATCH_TMPL, apiKey, providedClusterIdForApiKey);
            log.info(apiKeyClusterMismatchMessage);
            ErrorMessage apiKeyClusterMismatch = new ErrorMessage(Response.Status.FORBIDDEN.getStatusCode(), apiKeyClusterMismatchMessage);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)apiKeyClusterMismatch).build();
        }
        return null;
    }

    private static void setSecurityContext(CloudPrincipal cloudPrincipal, ContainerRequestContext requestContext) {
        boolean isSecure = requestContext.getUriInfo().getRequestUri().toString().startsWith("https");
        requestContext.setSecurityContext((SecurityContext)new CloudSecurityContext(cloudPrincipal, isSecure));
    }
}

