/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.auth.KafkaRestContextFactory;
import java.security.Principal;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;

public final class CloudExtensionsContextFilter
implements ContainerRequestFilter {
    private final KafkaRestConfig config;

    @Inject
    public CloudExtensionsContextFilter(KafkaRestConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    public void filter(ContainerRequestContext requestContext) {
        Principal principal = requestContext.getSecurityContext().getUserPrincipal();
        KafkaRestContext context = KafkaRestContextFactory.create(principal, this.config);
        requestContext.setProperty("io.confluent.kafkarest.backends.kafka.CloudKafkaModule.KafkaRestContext", (Object)context);
    }
}

