/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.common.base.Preconditions;
import io.confluent.kafkarest.DefaultKafkaRestContext;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.auth.CloudPrincipal;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudKafkaRestContext
implements KafkaRestContext {
    private static final Logger log = LoggerFactory.getLogger(CloudKafkaRestContext.class);
    private final DefaultKafkaRestContext delegate;
    @Nullable
    private volatile CloudPrincipal principal;
    @Nullable
    private Admin adminClient;
    @Nullable
    private volatile Producer<byte[], byte[]> producer;

    public CloudKafkaRestContext(CloudPrincipal principal, KafkaRestConfig config) {
        log.debug("Creating context with config: {}", (Object)config);
        this.principal = Objects.requireNonNull(principal);
        this.delegate = new DefaultKafkaRestContext(config);
    }

    public KafkaRestConfig getConfig() {
        return this.delegate.getConfig();
    }

    public KafkaConsumerManager getKafkaConsumerManager() {
        throw new UnsupportedOperationException();
    }

    public synchronized Admin getAdmin() {
        if (this.adminClient == null) {
            this.adminClient = AdminClient.create((Properties)this.getAdminProperties());
        }
        return this.adminClient;
    }

    public Properties getAdminProperties() {
        Preconditions.checkState((this.principal != null ? 1 : 0) != 0);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.delegate.getConfig().getAdminProperties());
        properties.putAll((Map<?, ?>)this.principal.getClientConfigs());
        return properties;
    }

    Map<String, Object> getProducerConfigs() {
        Preconditions.checkState((this.principal != null ? 1 : 0) != 0);
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.putAll(this.delegate.getConfig().getProducerConfigs());
        configs.putAll((Map<String, Object>)this.principal.getClientConfigs());
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Producer<byte[], byte[]> getProducer() {
        KafkaProducer localProducer = this.producer;
        if (localProducer == null) {
            CloudKafkaRestContext cloudKafkaRestContext = this;
            synchronized (cloudKafkaRestContext) {
                localProducer = this.producer;
                if (localProducer == null) {
                    this.producer = localProducer = new KafkaProducer(this.getProducerConfigs(), (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
                }
            }
        }
        return localProducer;
    }

    public synchronized void shutdown() {
        log.debug("Shutting down");
        this.principal = null;
        if (this.adminClient != null) {
            this.adminClient.close();
            this.adminClient = null;
        }
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
    }
}

