/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.clients.plugins.auth.jwt.UnverifiedJwtBearerToken;
import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafkarest.auth.AuthorizationHeader;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClientCallbackHandler;

public abstract class CloudPrincipal
implements Principal {
    private final String clusterId;

    private CloudPrincipal(String clusterId) {
        this.clusterId = Objects.requireNonNull(clusterId);
    }

    public static CloudPrincipal create(String clusterId, AuthorizationHeader header) {
        switch (header.getScheme()) {
            case BASIC: {
                return CloudPrincipal.fromBasicCredentials(clusterId, header.getCredentials());
            }
            case BEARER: {
                return CloudPrincipal.fromBearerCredentials(clusterId, header.getCredentials());
            }
        }
        throw new AssertionError((Object)String.format("Unknown scheme: %s", new Object[]{header.getScheme()}));
    }

    private static BasicCloudPrincipal fromBasicCredentials(String clusterId, String credentials) {
        String decoded = new String(Base64.getDecoder().decode(credentials), StandardCharsets.ISO_8859_1);
        int separator = decoded.indexOf(58);
        String apiKey = decoded.substring(0, separator);
        String apiSecret = decoded.substring(separator + 1);
        return new BasicCloudPrincipal(clusterId, apiKey, apiSecret);
    }

    private static BearerCloudPrincipal fromBearerCredentials(String clusterId, String credentials) {
        return new BearerCloudPrincipal(clusterId, (OAuthBearerToken)new UnverifiedJwtBearerToken(credentials));
    }

    public final String getClusterId() {
        return this.clusterId;
    }

    final String getClientId() {
        return "proxy:" + this.getName();
    }

    final String getSecurityProtocol() {
        return SecurityProtocol.SASL_SSL.name();
    }

    public abstract ImmutableMap<String, String> getClientConfigs();

    public abstract AuthorizationHeader.Scheme getScheme();

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudPrincipal that = (CloudPrincipal)o;
        return this.getClusterId().equals(that.getClusterId()) && this.getName().equals(that.getName());
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.getClusterId(), this.getName());
    }

    @Override
    public String toString() {
        return String.format("CloudPrincipal[name=%s, clusterId=%s]", this.getName(), this.getClusterId());
    }

    private static final class BearerCloudPrincipal
    extends CloudPrincipal {
        private final OAuthBearerToken token;

        private BearerCloudPrincipal(String clusterId, OAuthBearerToken token) {
            super(clusterId);
            this.token = Objects.requireNonNull(token);
        }

        @Override
        public String getName() {
            return this.token.principalName();
        }

        @Override
        public AuthorizationHeader.Scheme getScheme() {
            return AuthorizationHeader.Scheme.BEARER;
        }

        @Override
        public ImmutableMap<String, String> getClientConfigs() {
            return ImmutableMap.builder().put((Object)"client.id", (Object)this.getClientId()).put((Object)"security.protocol", (Object)this.getSecurityProtocol()).put((Object)"sasl.mechanism", (Object)this.getSaslMechanism()).put((Object)"sasl.client.callback.handler.class", (Object)this.getSaslClientCallbackHandlerClass()).put((Object)"sasl.login.callback.handler.class", (Object)this.getSaslLoginCallbackHandlerClass()).put((Object)"sasl.jaas.config", (Object)this.getSaslJaasConfig()).build();
        }

        private String getSaslMechanism() {
            return "OAUTHBEARER";
        }

        private String getSaslClientCallbackHandlerClass() {
            return OAuthBearerSaslClientCallbackHandler.class.getName();
        }

        private String getSaslLoginCallbackHandlerClass() {
            return OAuthBearerLoginCallbackHandler.class.getName();
        }

        private String getSaslJaasConfig() {
            return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required token=\"" + this.token.value() + "\" cluster=\"" + this.getClusterId() + "\";";
        }
    }

    private static final class BasicCloudPrincipal
    extends CloudPrincipal {
        private static final Pattern JAAS_INPUT_PATTERN = Pattern.compile("(\"|\n|\r|\\$\\{)");
        private final String apiKey;
        private final String apiSecret;

        private BasicCloudPrincipal(String clusterId, String apiKey, String apiSecret) {
            super(clusterId);
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
        }

        @Override
        public String getName() {
            return this.apiKey;
        }

        @Override
        public AuthorizationHeader.Scheme getScheme() {
            return AuthorizationHeader.Scheme.BASIC;
        }

        @Override
        public ImmutableMap<String, String> getClientConfigs() {
            return ImmutableMap.builder().put((Object)"client.id", (Object)this.getClientId()).put((Object)"security.protocol", (Object)this.getSecurityProtocol()).put((Object)"sasl.mechanism", (Object)this.getSaslMechanism()).put((Object)"sasl.jaas.config", (Object)this.getSaslJaasConfig()).build();
        }

        private String getSaslMechanism() {
            return "PLAIN";
        }

        private String getSaslJaasConfig() {
            return "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + JAAS_INPUT_PATTERN.matcher(this.apiKey).replaceAll("") + "\" password=\"" + JAAS_INPUT_PATTERN.matcher(this.apiSecret).replaceAll("") + "\";";
        }
    }
}

