/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.AbstractConfigManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.entities.AbstractConfig;
import io.confluent.kafkarest.entities.AlterConfigCommand;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.config.ConfigResource;

abstract class AbstractClusterLinkingConfigManager<T extends AbstractConfig, B extends AbstractConfig.Builder<T, B>>
extends AbstractConfigManager<T, B> {
    AbstractClusterLinkingConfigManager(Admin adminClient, ClusterManager clusterManager) {
        super(adminClient, clusterManager);
    }

    final CompletableFuture<Void> safeAlterConfigs(String clusterId, ConfigResource resourceId, B prototype, List<AlterConfigCommand> commands, boolean validateOnly) {
        if (!validateOnly) {
            return super.safeAlterConfigs(clusterId, resourceId, prototype, commands);
        }
        return this.listConfigs(clusterId, resourceId, (AbstractConfig.Builder)prototype).thenAccept(configs -> {
            Set configNames = configs.stream().map(AbstractConfig::getName).collect(Collectors.toSet());
            for (AlterConfigCommand command : commands) {
                if (configNames.contains(command.getName())) continue;
                throw new NotFoundException(String.format("Config %s cannot be found for %s %s in cluster %s.", command.getName(), resourceId.type(), resourceId.name(), clusterId));
            }
        });
    }
}

