/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.collect.Iterables;
import io.confluent.kafkarest.common.CompletableFutures;
import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.BrokerManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.ExtensionsBrokerManager;
import io.confluent.kafkarest.entities.BrokerRemoval;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.exceptions.BalancerOfflineException;
import io.confluent.kafkarest.exceptions.BrokerNotFoundException;
import io.confluent.kafkarest.exceptions.IllegalBrokerRemovalException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.BrokerIdNotRegisteredException;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.errors.UnsupportedVersionException;

final class ExtensionsBrokerManagerImpl
implements ExtensionsBrokerManager {
    private final ClusterManager clusterManager;
    private final BrokerManager brokerManager;
    private final ConfluentAdmin confluentAdminClient;

    @Inject
    ExtensionsBrokerManagerImpl(ClusterManager clusterManager, BrokerManager brokerManager, ConfluentAdmin confluentAdminClient) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.brokerManager = Objects.requireNonNull(brokerManager);
        this.confluentAdminClient = Objects.requireNonNull(confluentAdminClient);
    }

    @Override
    public CompletableFuture<BrokerRemoval> removeBroker(String clusterId, Integer brokerId, boolean shouldShutdown) {
        Objects.requireNonNull(brokerId);
        return this.removeBrokers(clusterId, Collections.singletonList(brokerId), shouldShutdown).thenApply(Iterables::getOnlyElement);
    }

    @Override
    public CompletableFuture<List<BrokerRemoval>> removeBrokers(String clusterId, List<Integer> brokerIds, boolean shouldShutdown) {
        Objects.requireNonNull(clusterId);
        Objects.requireNonNull(brokerIds);
        RemoveBrokersOptions removeBrokersOptions = new RemoveBrokersOptions().shouldShutdownBrokers(shouldShutdown);
        CompletionStage result = ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.removeBrokers(brokerIds, removeBrokersOptions).all()))).thenApply(brokers -> brokers.stream().map(brokerId -> ExtensionsBrokerManagerImpl.toBrokerRemoval(clusterId, brokerId)).collect(Collectors.toList()));
        return ExtensionsBrokerManagerImpl.catchSbkOfflineException(CompletableFutures.catchingCompose((CompletableFuture)result, InvalidBrokerRemovalException.class, e -> CompletableFutures.allAsList(brokerIds.stream().map(brokerId -> this.brokerManager.getBroker(clusterId, brokerId.intValue()).thenApply(broker -> {
            if (broker.isPresent()) {
                throw new IllegalBrokerRemovalException((Throwable)e);
            }
            throw new BrokerNotFoundException(clusterId, (int)brokerId);
        })).collect(Collectors.toList())).thenApply(brokers -> null)));
    }

    @Override
    public CompletableFuture<Void> unregisterBroker(String clusterId, Integer brokerId) {
        Objects.requireNonNull(clusterId);
        Objects.requireNonNull(brokerId);
        CompletionStage result = ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.unregisterBroker(brokerId.intValue()).all()));
        return ExtensionsBrokerManagerImpl.catchBrokerIdNotRegisteredException(ExtensionsBrokerManagerImpl.catchUnsupportedVersionException(result), clusterId, brokerId);
    }

    static <T> CompletableFuture<T> catchUnsupportedVersionException(CompletableFuture<T> future) {
        return CompletableFutures.catchingCompose(future, UnsupportedVersionException.class, e -> {
            throw new io.confluent.kafkarest.exceptions.UnsupportedVersionException(e.getMessage());
        });
    }

    static <T> CompletableFuture<T> catchBrokerIdNotRegisteredException(CompletableFuture<T> future, String clusterId, Integer brokerId) {
        return CompletableFutures.catchingCompose(future, BrokerIdNotRegisteredException.class, e -> {
            throw new io.confluent.kafkarest.exceptions.BrokerIdNotRegisteredException(String.format("The given broker %d was not found to be registered in cluster %s.", brokerId, clusterId));
        });
    }

    static <T> CompletableFuture<T> catchSbkOfflineException(CompletableFuture<T> future) {
        return CompletableFutures.catchingCompose(future, org.apache.kafka.common.errors.BalancerOfflineException.class, e -> {
            throw new BalancerOfflineException((Exception)e);
        });
    }

    static BrokerRemoval toBrokerRemoval(String clusterId, int brokerId) {
        return BrokerRemoval.builder().setClusterId(clusterId).setBrokerId(brokerId).build();
    }
}

