/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafkarest.entities.Balancer;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.BalancerStatus;

final class AutoValue_Balancer
extends Balancer {
    private final String clusterId;
    private final BalancerStatus status;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;

    private AutoValue_Balancer(String clusterId, BalancerStatus status, Optional<Short> errorCode, Optional<String> errorMessage) {
        this.clusterId = clusterId;
        this.status = status;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public BalancerStatus getStatus() {
        return this.status;
    }

    @Override
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "Balancer{clusterId=" + this.clusterId + ", status=" + this.status + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Balancer) {
            Balancer that = (Balancer)o;
            return this.clusterId.equals(that.getClusterId()) && this.status.equals((Object)that.getStatus()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.status.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorMessage.hashCode();
    }

    static final class Builder
    extends Balancer.Builder {
        private String clusterId;
        private BalancerStatus status;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();

        Builder() {
        }

        @Override
        public Balancer.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public Balancer.Builder setStatus(BalancerStatus status) {
            if (status == null) {
                throw new NullPointerException("Null status");
            }
            this.status = status;
            return this;
        }

        @Override
        public Balancer.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public Balancer.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public Balancer build() {
            String missing = "";
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.status == null) {
                missing = missing + " status";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Balancer(this.clusterId, this.status, this.errorCode, this.errorMessage);
        }
    }
}

