/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.apache.kafka.clients.admin.MirrorTopicDescription;

public enum MirrorStatus {
    ACTIVE(MirrorTopicDescription.State.ACTIVE),
    FAILED(MirrorTopicDescription.State.FAILED),
    PAUSED(MirrorTopicDescription.State.PAUSED),
    STOPPED(MirrorTopicDescription.State.STOPPED),
    PENDING_STOPPED(MirrorTopicDescription.State.PENDING_STOPPED);

    private MirrorTopicDescription.State state;
    private static Set<String> VALID_NAMES;

    private MirrorStatus(MirrorTopicDescription.State state) {
        this.state = state;
    }

    public static MirrorStatus fromString(String name) {
        if (name == null) {
            return null;
        }
        String upper = name.toUpperCase();
        if (!VALID_NAMES.contains(upper)) {
            throw new BadRequestException("Unexpected mirror status: " + upper + ". valid status are: " + VALID_NAMES);
        }
        return MirrorStatus.valueOf(upper);
    }

    public MirrorTopicDescription.State getState() {
        return this.state;
    }

    static {
        VALID_NAMES = Arrays.stream(MirrorStatus.values()).map(Enum::name).collect(Collectors.toSet());
    }
}

