/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.BrokerReplicaExclusionData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_BrokerReplicaExclusionData
extends BrokerReplicaExclusionData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final int brokerId;
    private final String reason;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;
    private final Resource.Relationship broker;

    private AutoValue_BrokerReplicaExclusionData(String kind, Resource.Metadata metadata, String clusterId, int brokerId, String reason, Optional<Short> errorCode, Optional<String> errorMessage, Resource.Relationship broker) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.reason = reason;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.broker = broker;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="broker_id")
    public int getBrokerId() {
        return this.brokerId;
    }

    @Override
    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @Override
    @JsonProperty(value="error_code")
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="error_message")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="broker")
    public Resource.Relationship getBroker() {
        return this.broker;
    }

    public String toString() {
        return "BrokerReplicaExclusionData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", brokerId=" + this.brokerId + ", reason=" + this.reason + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", broker=" + this.broker + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BrokerReplicaExclusionData) {
            BrokerReplicaExclusionData that = (BrokerReplicaExclusionData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.brokerId == that.getBrokerId() && this.reason.equals(that.getReason()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage()) && this.broker.equals(that.getBroker());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerId;
        h$ *= 1000003;
        h$ ^= this.reason.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorMessage.hashCode();
        h$ *= 1000003;
        return h$ ^= this.broker.hashCode();
    }

    static final class Builder
    extends BrokerReplicaExclusionData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private Integer brokerId;
        private String reason;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();
        private Resource.Relationship broker;

        Builder() {
        }

        public BrokerReplicaExclusionData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public BrokerReplicaExclusionData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public BrokerReplicaExclusionData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public BrokerReplicaExclusionData.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public BrokerReplicaExclusionData.Builder setReason(String reason) {
            if (reason == null) {
                throw new NullPointerException("Null reason");
            }
            this.reason = reason;
            return this;
        }

        @Override
        public BrokerReplicaExclusionData.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public BrokerReplicaExclusionData.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public BrokerReplicaExclusionData.Builder setBroker(Resource.Relationship broker) {
            if (broker == null) {
                throw new NullPointerException("Null broker");
            }
            this.broker = broker;
            return this;
        }

        @Override
        public BrokerReplicaExclusionData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.brokerId == null) {
                missing = missing + " brokerId";
            }
            if (this.reason == null) {
                missing = missing + " reason";
            }
            if (this.broker == null) {
                missing = missing + " broker";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BrokerReplicaExclusionData(this.kind, this.metadata, this.clusterId, this.brokerId, this.reason, this.errorCode, this.errorMessage, this.broker);
        }
    }
}

