/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.CreateLinkRequest;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_CreateLinkRequest
extends CreateLinkRequest {
    private final ImmutableList<CreateLinkRequest.ConfigEntry> configs;
    private final Optional<String> sourceClusterId;
    private final Optional<String> destinationClusterId;

    private AutoValue_CreateLinkRequest(ImmutableList<CreateLinkRequest.ConfigEntry> configs, Optional<String> sourceClusterId, Optional<String> destinationClusterId) {
        this.configs = configs;
        this.sourceClusterId = sourceClusterId;
        this.destinationClusterId = destinationClusterId;
    }

    @Override
    @JsonProperty(value="configs")
    public ImmutableList<CreateLinkRequest.ConfigEntry> getConfigs() {
        return this.configs;
    }

    @Override
    @JsonProperty(value="source_cluster_id")
    public Optional<String> getSourceClusterId() {
        return this.sourceClusterId;
    }

    @Override
    @JsonProperty(value="destination_cluster_id")
    public Optional<String> getDestinationClusterId() {
        return this.destinationClusterId;
    }

    public String toString() {
        return "CreateLinkRequest{configs=" + this.configs + ", sourceClusterId=" + this.sourceClusterId + ", destinationClusterId=" + this.destinationClusterId + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CreateLinkRequest) {
            CreateLinkRequest that = (CreateLinkRequest)o;
            return this.configs.equals(that.getConfigs()) && this.sourceClusterId.equals(that.getSourceClusterId()) && this.destinationClusterId.equals(that.getDestinationClusterId());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.configs.hashCode();
        h$ *= 1000003;
        h$ ^= this.sourceClusterId.hashCode();
        h$ *= 1000003;
        return h$ ^= this.destinationClusterId.hashCode();
    }

    static final class Builder
    extends CreateLinkRequest.Builder {
        private ImmutableList<CreateLinkRequest.ConfigEntry> configs;
        private Optional<String> sourceClusterId = Optional.empty();
        private Optional<String> destinationClusterId = Optional.empty();

        Builder() {
        }

        @Override
        public CreateLinkRequest.Builder setConfigs(List<CreateLinkRequest.ConfigEntry> configs) {
            this.configs = ImmutableList.copyOf(configs);
            return this;
        }

        @Override
        public CreateLinkRequest.Builder setSourceClusterId(@Nullable String sourceClusterId) {
            this.sourceClusterId = Optional.ofNullable(sourceClusterId);
            return this;
        }

        @Override
        public CreateLinkRequest.Builder setDestinationClusterId(@Nullable String destinationClusterId) {
            this.destinationClusterId = Optional.ofNullable(destinationClusterId);
            return this;
        }

        @Override
        public CreateLinkRequest build() {
            String missing = "";
            if (this.configs == null) {
                missing = missing + " configs";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CreateLinkRequest(this.configs, this.sourceClusterId, this.destinationClusterId);
        }
    }
}

