/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Link;
import io.confluent.kafkarest.entities.v3.AutoValue_LinkData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.ClusterLinkDescription;

@AutoValue
public abstract class LinkData
extends Resource {
    LinkData() {
    }

    @JsonProperty(value="source_cluster_id")
    @Nullable
    public abstract String getSourceClusterId();

    @JsonProperty(value="destination_cluster_id")
    @Nullable
    public abstract String getDestinationClusterId();

    @JsonProperty(value="link_name")
    public abstract String getLinkName();

    @JsonProperty(value="link_id")
    public abstract UUID getLinkId();

    @JsonProperty(value="cluster_link_id")
    public abstract String getClusterLinkId();

    @JsonProperty(value="topic_names")
    public abstract ImmutableList<String> getTopics();

    public static Builder builder() {
        return new AutoValue_LinkData.Builder().setKind("KafkaLinkData");
    }

    public static Builder fromLinkData(LinkData linkData) {
        return LinkData.builder().setLinkName(linkData.getLinkName()).setSourceClusterId(linkData.getSourceClusterId()).setDestinationClusterId(linkData.getDestinationClusterId()).setLinkId(linkData.getLinkId()).setClusterLinkId(linkData.getClusterLinkId().toString()).setTopics(linkData.getTopics());
    }

    public static Builder fromLink(Link link) {
        String sourceClusterId = link.getLinkMode() == ClusterLinkDescription.LinkMode.DESTINATION ? link.getRemoteClusterId() : null;
        String destinationClusterId = link.getLinkMode() == ClusterLinkDescription.LinkMode.SOURCE ? link.getRemoteClusterId() : null;
        return LinkData.builder().setLinkName(link.getLinkName()).setSourceClusterId(sourceClusterId).setDestinationClusterId(destinationClusterId).setLinkId(link.getLinkId()).setClusterLinkId(link.getClusterLinkId().toString()).setTopics(link.getTopics());
    }

    @JsonCreator
    static LinkData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="source_cluster_id") String sourceClusterId, @JsonProperty(value="destination_cluster_id") String destinationClusterId, @JsonProperty(value="link_name") String linkName, @JsonProperty(value="link_id") UUID linkId, @JsonProperty(value="cluster_link_id") String clusterLinkId, @JsonProperty(value="topic_names") ImmutableList<String> topics) {
        return ((Builder)((Builder)LinkData.builder().setKind(kind)).setMetadata(metadata)).setLinkName(linkName).setSourceClusterId(sourceClusterId).setDestinationClusterId(destinationClusterId).setLinkId(linkId).setClusterLinkId(clusterLinkId).setTopics(topics).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setSourceClusterId(String var1);

        public abstract Builder setDestinationClusterId(String var1);

        public abstract Builder setLinkName(String var1);

        public abstract Builder setLinkId(UUID var1);

        public abstract Builder setClusterLinkId(String var1);

        public abstract Builder setTopics(ImmutableList<String> var1);

        public abstract LinkData build();
    }
}

