/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Mirror;
import io.confluent.kafkarest.entities.v3.AutoValue_MirrorDataList;
import io.confluent.kafkarest.entities.v3.MirrorData;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import java.util.List;

@AutoValue
public abstract class MirrorDataList
extends ResourceCollection<MirrorData> {
    MirrorDataList() {
    }

    public static Builder builder() {
        return new AutoValue_MirrorDataList.Builder().setKind("KafkaMirrorDataList");
    }

    public static Builder builder(String mirrorResourceUrl, List<Mirror> mirrors) {
        return (Builder)((Builder)MirrorDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(mirrorResourceUrl).build())).setData(MirrorData.fromMirrors(mirrors, mirrorResourceUrl));
    }

    @JsonCreator
    static MirrorDataList fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") ResourceCollection.Metadata metadata, @JsonProperty(value="data") ImmutableList<MirrorData> data) {
        return (MirrorDataList)((Builder)((Builder)((Builder)MirrorDataList.builder().setKind(kind)).setMetadata(metadata)).setData((List)data)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends ResourceCollection.Builder<MirrorData, MirrorDataList, Builder> {
        Builder() {
        }
    }
}

