/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.exceptions;

import io.confluent.kafkarest.exceptions.StatusCodeException;
import java.util.Optional;
import javax.ws.rs.core.Response;

public final class TopicPartitionNotFoundException
extends StatusCodeException {
    public TopicPartitionNotFoundException(String clusterId, String topicName, Optional<Integer> partitionId, String errorMessage) {
        super(Response.Status.NOT_FOUND, "TopicPartition not found.", String.format("TopicPartition: %s%s not found in the cluster: %s, error was: %s", topicName, partitionId.map(e -> "-" + e).orElse(""), clusterId, errorMessage));
    }

    public TopicPartitionNotFoundException(String clusterId, String topicName, String errorMessage) {
        super(Response.Status.NOT_FOUND, "TopicPartition not found.", String.format("Topic: %s not found in the cluster: %s, error was: %s", topicName, clusterId, errorMessage));
    }
}

