/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.BrokerTaskManager;
import io.confluent.kafkarest.entities.BrokerTask;
import io.confluent.kafkarest.entities.BrokerTaskType;
import io.confluent.kafkarest.entities.v3.BrokerTaskData;
import io.confluent.kafkarest.entities.v3.BrokerTaskDataList;
import io.confluent.kafkarest.entities.v3.ListBrokerTaskResponse;
import io.confluent.kafkarest.entities.v3.ListBrokerTasksByTaskTypeResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/brokers/-/tasks")
@ResourceAccesslistFeature.ResourceName(value="api.v3.broker-tasks.*")
public final class BrokerTaskResource {
    private final Provider<BrokerTaskManager> brokerTaskManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public BrokerTaskResource(Provider<BrokerTaskManager> taskBrokerManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.brokerTaskManager = Objects.requireNonNull(taskBrokerManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.broker-tasks.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-tasks.list")
    public void listBrokerTasks(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((BrokerTaskManager)this.brokerTaskManager.get()).listBrokerTasks(clusterId).thenApply(brokerTasks -> ListBrokerTaskResponse.create((BrokerTaskDataList)((BrokerTaskDataList.Builder)((BrokerTaskDataList.Builder)BrokerTaskDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "brokers", "-", "tasks"})).build())).setData(brokerTasks.stream().map(brokerTask -> BrokerTaskResource.toBrokerTaskData(this.urlFactory, this.crnFactory, brokerTask)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    @GET
    @Path(value="/{taskType}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.broker-tasks.search-by-type")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-tasks.search-by-type")
    public void listBrokerTasksByTaskType(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="taskType") BrokerTaskType taskType) {
        CompletionStage response = ((BrokerTaskManager)this.brokerTaskManager.get()).listBrokerTasksByTaskType(clusterId, taskType).thenApply(brokerTasks -> ListBrokerTasksByTaskTypeResponse.create((BrokerTaskDataList)((BrokerTaskDataList.Builder)((BrokerTaskDataList.Builder)BrokerTaskDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "brokers", "-", "tasks", taskType.getBrokerTaskType()})).build())).setData(brokerTasks.stream().map(brokerTask -> BrokerTaskResource.toBrokerTaskData(this.urlFactory, this.crnFactory, brokerTask)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    static BrokerTaskData toBrokerTaskData(UrlFactory urlFactory, CrnFactory crnFactory, BrokerTask brokerTask) {
        return ((BrokerTaskData.Builder)BrokerTaskData.fromBrokerTask(brokerTask).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create(new String[]{"v3", "clusters", brokerTask.getClusterId(), "brokers", Integer.toString(brokerTask.getBrokerId()), "tasks", brokerTask.getTaskType().getBrokerTaskType()})).setResourceName(crnFactory.create(new String[]{"kafka", brokerTask.getClusterId(), "broker", Integer.toString(brokerTask.getBrokerId()), "task", brokerTask.getTaskType().getBrokerTaskType()})).build())).setBroker(Resource.Relationship.create((String)urlFactory.create(new String[]{"v3", "clusters", brokerTask.getClusterId(), "brokers", Integer.toString(brokerTask.getBrokerId())}))).build();
    }
}

