/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.Time;
import io.confluent.kafkarest.auth.CloudPrincipal;
import io.confluent.kafkarest.resources.v3.ProducerMetrics;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudV3ResourcesModule
extends AbstractBinder {
    private static final Logger log = LoggerFactory.getLogger(CloudV3ResourcesModule.class);

    protected void configure() {
        this.bindFactory(CloudProducerMetricsFactory.class).to(ProducerMetrics.class).in(RequestScoped.class).ranked(1);
    }

    private static final class CloudProducerMetricsFactory
    implements Factory<ProducerMetrics> {
        private final Provider<KafkaRestConfig> config;
        private final Provider<ContainerRequestContext> context;

        @Inject
        CloudProducerMetricsFactory(Provider<KafkaRestConfig> config, Provider<ContainerRequestContext> context) {
            this.config = Objects.requireNonNull(config);
            this.context = Objects.requireNonNull(context);
        }

        public ProducerMetrics provide() {
            return new ProducerMetrics((KafkaRestConfig)this.config.get(), Time.SYSTEM, (Map)ImmutableMap.of((Object)"tenant", (Object)((CloudPrincipal)((ContainerRequestContext)this.context.get()).getSecurityContext().getUserPrincipal()).getClusterId()));
        }

        public void dispose(ProducerMetrics producerMetrics) {
        }
    }
}

