/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.BrokerReplicaExclusionManager;
import io.confluent.kafkarest.entities.v3.AlterBrokerReplicaExclusionDataList;
import io.confluent.kafkarest.entities.v3.BrokerReplicaExclusionBatchRequest;
import io.confluent.kafkarest.entities.v3.ListAlterBrokerReplicaExclusionResponse;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.resources.v3.BrokerReplicaExclusionResource;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/broker-replica-exclusions:create")
@ResourceAccesslistFeature.ResourceName(value="api.v3.broker-replica-exclusions.*")
public final class CreateBrokerReplicaExclusionBatchAction {
    private final Provider<BrokerReplicaExclusionManager> brokerReplicaExclusionManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public CreateBrokerReplicaExclusionBatchAction(Provider<BrokerReplicaExclusionManager> brokerReplicaExclusionManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.brokerReplicaExclusionManager = Objects.requireNonNull(brokerReplicaExclusionManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.broker-replica-exclusions.create")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-replica-exclusions.create")
    public void createBrokerReplicaExclusion(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @Valid BrokerReplicaExclusionBatchRequest request) {
        CompletionStage response = ((BrokerReplicaExclusionManager)this.brokerReplicaExclusionManager.get()).createBrokerReplicaExclusions(clusterId, request).thenApply(alterBrokerReplicaExclusions -> ListAlterBrokerReplicaExclusionResponse.create((AlterBrokerReplicaExclusionDataList)((AlterBrokerReplicaExclusionDataList.Builder)((AlterBrokerReplicaExclusionDataList.Builder)AlterBrokerReplicaExclusionDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "broker-replica-exclusions"})).build())).setData(alterBrokerReplicaExclusions.stream().map(alterBrokerReplicaExclusion -> BrokerReplicaExclusionResource.toAlterBrokerReplicaExclusionData(this.urlFactory, this.crnFactory, alterBrokerReplicaExclusion)).collect(Collectors.toList()))).build()));
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.ok()).entity((CompletableFuture)response).status(ListAlterBrokerReplicaExclusionResponse::getRequestStatus).asyncResume(asyncResponse);
    }
}

