/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ExtensionsBrokerManager;
import io.confluent.kafkarest.entities.v3.BrokerRemovalDataList;
import io.confluent.kafkarest.entities.v3.ListBrokerRemovalResponse;
import io.confluent.kafkarest.entities.v3.RemoveBrokersRequest;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.resources.v3.ExtensionsBrokersResource;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/brokers:delete")
@ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.*")
public final class ExtensionsBrokerAction {
    private final Provider<ExtensionsBrokerManager> extensionsBrokerManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ExtensionsBrokerAction(Provider<ExtensionsBrokerManager> extensionsBrokerManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.extensionsBrokerManager = Objects.requireNonNull(extensionsBrokerManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.delete")
    public void removeBrokers(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @QueryParam(value="should_shutdown") @DefaultValue(value="true") boolean shouldShutdown, @Valid RemoveBrokersRequest request) {
        CompletionStage response = ((ExtensionsBrokerManager)this.extensionsBrokerManager.get()).removeBrokers(clusterId, (List<Integer>)request.getBrokerIds(), shouldShutdown).thenApply(brokerRemovals -> ListBrokerRemovalResponse.create((BrokerRemovalDataList)((BrokerRemovalDataList.Builder)((BrokerRemovalDataList.Builder)BrokerRemovalDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "brokers:delete"})).build())).setData(brokerRemovals.stream().map(brokerRemoval -> ExtensionsBrokersResource.toBrokerRemovalData(this.urlFactory, this.crnFactory, brokerRemoval)).collect(Collectors.toList()))).build()));
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.ACCEPTED)).entity((CompletableFuture)response).asyncResume(asyncResponse);
    }
}

