/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.common.utils;

import com.linkedin.cruisecontrol.exception.CruiseControlException;
import java.util.Collection;
import java.util.Iterator;

public class Utils {
    private Utils() {
    }

    public static <T> T newInstance(Class<T> c) throws CruiseControlException {
        if (c == null) {
            throw new CruiseControlException("class cannot be null");
        }
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CruiseControlException("Could not find a public no-argument constructor for " + c.getName(), e);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new CruiseControlException("Could not instantiate class " + c.getName(), e);
        }
    }

    public static <T> T newInstance(String klass, Class<T> base) throws ClassNotFoundException, CruiseControlException {
        return Utils.newInstance(Class.forName(klass, true, Utils.getContextOrCruiseControlClassLoader()).asSubclass(base));
    }

    public static ClassLoader getContextOrCruiseControlClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return Utils.getCruiseControlClassLoader();
        }
        return cl;
    }

    public static ClassLoader getCruiseControlClassLoader() {
        return Utils.class.getClassLoader();
    }

    public static <T> String join(Collection<T> list, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static double[] expandArrayFromTheBeginning(double[] inputArray, int desiredLength) {
        if (inputArray.length >= desiredLength) {
            throw new IllegalArgumentException("Cannot extend the given array since its length is higher or equal to the desired length.");
        }
        double[] expandedArray = new double[desiredLength];
        System.arraycopy(inputArray, 0, expandedArray, desiredLength - inputArray.length, inputArray.length);
        return expandedArray;
    }
}

