/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class AggregatedMetricValues {
    private final Map<Short, MetricValues> metricValues;

    public AggregatedMetricValues() {
        this.metricValues = new HashMap<Short, MetricValues>();
    }

    public AggregatedMetricValues(Map<Short, MetricValues> valuesByMetricId) {
        if (valuesByMetricId == null) {
            throw new IllegalArgumentException("The metric values cannot be null");
        }
        int length = valuesByMetricId.isEmpty() ? -1 : valuesByMetricId.values().iterator().next().length();
        for (MetricValues values : valuesByMetricId.values()) {
            if (length == values.length()) continue;
            throw new IllegalArgumentException("The metric values must have the same length for each metric. Saw two different lengths of " + length + " and " + values.length());
        }
        this.metricValues = valuesByMetricId;
    }

    public MetricValues valuesFor(short metricId) {
        return this.metricValues.get(metricId);
    }

    public AggregatedMetricValues valuesFor(Collection<Short> metricIds, boolean shareValueArray) {
        AggregatedMetricValues values = new AggregatedMetricValues();
        metricIds.forEach(id -> {
            MetricValues valuesForId = this.metricValues.get(id);
            if (valuesForId == null) {
                throw new IllegalArgumentException("Metric id " + id + " does not exist.");
            }
            if (shareValueArray) {
                values.metricValues().put((Short)id, valuesForId);
            } else {
                values.add((short)id, valuesForId);
            }
        });
        return values;
    }

    public MetricValues valuesForResource(Resource resource, MetricDef metricDef, boolean shareValueArray) {
        List<MetricInfo> metricInfos = metricDef.metricInfoForResource(resource);
        if (metricInfos.size() == 1 && shareValueArray) {
            return this.metricValues.get(((MetricInfo)metricInfos.iterator().next()).id());
        }
        MetricValues metricValues = new MetricValues(this.length());
        metricInfos.forEach(info -> {
            MetricValues valuesForId = this.metricValues.get(info.id());
            if (valuesForId == null) {
                throw new IllegalArgumentException("Metric " + info + " does not exist.");
            }
            metricValues.add(valuesForId);
        });
        return metricValues;
    }

    public int length() {
        return this.metricValues.isEmpty() ? 0 : this.metricValues.values().iterator().next().length();
    }

    public boolean isEmpty() {
        return this.metricValues.isEmpty();
    }

    public Set<Short> metricIds() {
        return Collections.unmodifiableSet(this.metricValues.keySet());
    }

    public void add(short metricId, MetricValues metricValuesToAdd) {
        if (metricValuesToAdd == null) {
            throw new IllegalArgumentException("The metric values to be added cannot be null");
        }
        if (!this.metricValues.isEmpty() && metricValuesToAdd.length() != this.length()) {
            throw new IllegalArgumentException("The existing metric length is " + this.length() + " which is different from the metric length of " + metricValuesToAdd.length() + " that is being added.");
        }
        MetricValues metricValues = this.metricValues.computeIfAbsent(metricId, id -> new MetricValues(metricValuesToAdd.length()));
        metricValues.add(metricValuesToAdd);
    }

    public void add(AggregatedMetricValues other) {
        for (Map.Entry<Short, MetricValues> entry : other.metricValues().entrySet()) {
            short metricId = entry.getKey();
            MetricValues otherValuesForMetric = entry.getValue();
            MetricValues valuesForMetric = this.metricValues.computeIfAbsent(metricId, id -> new MetricValues(otherValuesForMetric.length()));
            if (valuesForMetric.length() != otherValuesForMetric.length()) {
                throw new IllegalStateException("The two values arrays have different lengths " + valuesForMetric.length() + " and " + otherValuesForMetric.length());
            }
            valuesForMetric.add(otherValuesForMetric);
        }
    }

    public void subtract(AggregatedMetricValues other) {
        for (Map.Entry<Short, MetricValues> entry : other.metricValues().entrySet()) {
            short metricId = entry.getKey();
            MetricValues otherValuesForMetric = entry.getValue();
            MetricValues valuesForMetric = this.valuesFor(metricId);
            if (valuesForMetric == null) {
                throw new IllegalStateException("Cannot subtract a values from a non-existing MetricValues");
            }
            if (valuesForMetric.length() != otherValuesForMetric.length()) {
                throw new IllegalStateException("The two values arrays have different lengths " + valuesForMetric.length() + " and " + otherValuesForMetric.length());
            }
            valuesForMetric.subtract(otherValuesForMetric);
        }
    }

    public void clear() {
        this.metricValues.clear();
    }

    public void writeTo(OutputStream out) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        osw.write("{%n");
        for (Map.Entry<Short, MetricValues> entry : this.metricValues.entrySet()) {
            osw.write(String.format("metricId:\"%d\", values:\"", entry.getKey()));
            entry.getValue().writeTo(out);
            osw.write("}\"");
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("\n", "{", "}");
        for (Map.Entry<Short, MetricValues> entry : this.metricValues.entrySet()) {
            joiner.add(String.format("metricId:\"%d\", values:\"%s\"", entry.getKey(), entry.getValue()));
        }
        return joiner.toString();
    }

    public boolean isEqual(AggregatedMetricValues other) {
        if (this == other) {
            return true;
        }
        return this.metricValues.size() == other.metricValues.size() && this.metricValues.entrySet().stream().allMatch(entry -> ((MetricValues)entry.getValue()).isEqual(other.metricValues.get(entry.getKey())));
    }

    private Map<Short, MetricValues> metricValues() {
        return this.metricValues;
    }
}

