/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BalancingConstraint {
    private final List<Resource> resources = Collections.unmodifiableList(Arrays.asList(Resource.DISK, Resource.NW_IN, Resource.NW_OUT, Resource.CPU, Resource.PRODUCE_IN));
    private final Map<Resource, Double> resourceBalancePercentage;
    private final Double replicaBalancePercentage;
    private final Double leaderReplicaBalancePercentage;
    private final Double topicReplicaBalancePercentage;
    private final Double goalViolationDistributionThresholdMultiplier;
    private final Map<Resource, Double> capacityThreshold;
    private final double capacityBalanceDeltaThreshold;
    private final Map<Resource, Double> lowUtilizationThreshold;
    private final Long maxReplicasPerBroker;
    private final Integer minFreeDiskSpaceGbPerBroker;
    private final Double minFreeDiskSpaceMiBPerBroker;
    private final Double hotPartitionResourceThresholdPercentage;

    public BalancingConstraint(KafkaCruiseControlConfig config) {
        this.resourceBalancePercentage = new HashMap<Resource, Double>(this.resources.size());
        this.capacityThreshold = new HashMap<Resource, Double>(this.resources.size());
        this.lowUtilizationThreshold = new HashMap<Resource, Double>(this.resources.size());
        this.capacityBalanceDeltaThreshold = config.getDouble("max.capacity.balancing.delta.percentage");
        this.resourceBalancePercentage.put(Resource.DISK, config.getDouble("disk.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.CPU, config.getDouble("cpu.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.NW_IN, config.getDouble("network.inbound.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.PRODUCE_IN, config.getDouble("network.inbound.balance.threshold"));
        this.resourceBalancePercentage.put(Resource.NW_OUT, config.getDouble("network.outbound.balance.threshold"));
        this.capacityThreshold.put(Resource.DISK, config.getDouble("disk.max.load"));
        this.capacityThreshold.put(Resource.CPU, config.getDouble("cpu.capacity.threshold"));
        this.capacityThreshold.put(Resource.NW_IN, config.getDouble("network.inbound.capacity.threshold"));
        this.capacityThreshold.put(Resource.PRODUCE_IN, config.getDouble("producer.inbound.capacity.threshold"));
        this.capacityThreshold.put(Resource.NW_OUT, config.getDouble("network.outbound.capacity.threshold"));
        this.lowUtilizationThreshold.put(Resource.DISK, config.getDouble("disk.low.utilization.threshold"));
        this.lowUtilizationThreshold.put(Resource.CPU, config.getDouble("cpu.low.utilization.threshold"));
        this.lowUtilizationThreshold.put(Resource.NW_IN, config.getDouble("network.inbound.low.utilization.threshold"));
        this.lowUtilizationThreshold.put(Resource.PRODUCE_IN, config.getDouble("network.inbound.low.utilization.threshold"));
        this.lowUtilizationThreshold.put(Resource.NW_OUT, config.getDouble("network.outbound.low.utilization.threshold"));
        this.maxReplicasPerBroker = config.getLong("max.replicas");
        this.replicaBalancePercentage = config.getDouble("replica.count.balance.threshold");
        this.leaderReplicaBalancePercentage = config.getDouble("leader.replica.count.balance.threshold");
        this.topicReplicaBalancePercentage = config.getDouble("topic.replica.count.balance.threshold");
        this.goalViolationDistributionThresholdMultiplier = config.getDouble("goal.violation.distribution.threshold.multiplier");
        this.hotPartitionResourceThresholdPercentage = config.getDouble("hot.partition.capacity.utilization.threshold");
        this.minFreeDiskSpaceGbPerBroker = config.getInt("disk.min.free.space.gb");
        this.minFreeDiskSpaceMiBPerBroker = KafkaCruiseControlUtils.gigabytesToMebibytes(this.minFreeDiskSpaceGbPerBroker.intValue());
    }

    public BalancingConstraint(BalancingConstraint original) {
        this.resourceBalancePercentage = new HashMap<Resource, Double>(original.resourceBalancePercentage);
        this.replicaBalancePercentage = original.replicaBalancePercentage;
        this.capacityBalanceDeltaThreshold = original.capacityBalanceDeltaThreshold;
        this.leaderReplicaBalancePercentage = original.leaderReplicaBalancePercentage;
        this.topicReplicaBalancePercentage = original.topicReplicaBalancePercentage;
        this.goalViolationDistributionThresholdMultiplier = original.goalViolationDistributionThresholdMultiplier;
        this.capacityThreshold = new HashMap<Resource, Double>(original.capacityThreshold);
        this.lowUtilizationThreshold = new HashMap<Resource, Double>(original.lowUtilizationThreshold);
        this.maxReplicasPerBroker = original.maxReplicasPerBroker;
        this.hotPartitionResourceThresholdPercentage = original.hotPartitionResourceThresholdPercentage;
        this.minFreeDiskSpaceGbPerBroker = original.minFreeDiskSpaceGbPerBroker;
        this.minFreeDiskSpaceMiBPerBroker = original.minFreeDiskSpaceMiBPerBroker;
    }

    public Properties setProps(Properties props) {
        props.put("disk.balance.threshold", this.resourceBalancePercentage.get((Object)Resource.DISK).toString());
        props.put("cpu.balance.threshold", this.resourceBalancePercentage.get((Object)Resource.CPU).toString());
        props.put("network.inbound.balance.threshold", this.resourceBalancePercentage.get((Object)Resource.NW_IN).toString());
        props.put("network.outbound.balance.threshold", this.resourceBalancePercentage.get((Object)Resource.NW_OUT).toString());
        props.put("disk.max.load", this.capacityThreshold.get((Object)Resource.DISK).toString());
        props.put("cpu.capacity.threshold", this.capacityThreshold.get((Object)Resource.CPU).toString());
        props.put("network.inbound.capacity.threshold", this.capacityThreshold.get((Object)Resource.NW_IN).toString());
        props.put("network.outbound.capacity.threshold", this.capacityThreshold.get((Object)Resource.NW_OUT).toString());
        props.put("producer.inbound.capacity.threshold", this.capacityThreshold.get((Object)Resource.PRODUCE_IN).toString());
        props.put("disk.min.free.space.gb", this.minFreeDiskSpaceGbPerBroker.toString());
        props.put("disk.low.utilization.threshold", this.lowUtilizationThreshold.get((Object)Resource.DISK).toString());
        props.put("cpu.low.utilization.threshold", this.lowUtilizationThreshold.get((Object)Resource.CPU).toString());
        props.put("network.inbound.low.utilization.threshold", this.lowUtilizationThreshold.get((Object)Resource.NW_IN).toString());
        props.put("network.outbound.low.utilization.threshold", this.lowUtilizationThreshold.get((Object)Resource.NW_OUT).toString());
        props.put("max.capacity.balancing.delta.percentage", Double.toString(this.capacityBalanceDeltaThreshold));
        props.put("max.replicas", this.maxReplicasPerBroker.toString());
        props.put("replica.count.balance.threshold", this.replicaBalancePercentage.toString());
        props.put("leader.replica.count.balance.threshold", this.leaderReplicaBalancePercentage.toString());
        props.put("topic.replica.count.balance.threshold", this.topicReplicaBalancePercentage.toString());
        props.put("goal.violation.distribution.threshold.multiplier", this.goalViolationDistributionThresholdMultiplier.toString());
        props.put("hot.partition.capacity.utilization.threshold", this.hotPartitionResourceThresholdPercentage.toString());
        return props;
    }

    public List<Resource> resources() {
        return this.resources;
    }

    public Long maxReplicasPerBroker() {
        return this.maxReplicasPerBroker;
    }

    public Double replicaBalancePercentage() {
        return this.replicaBalancePercentage;
    }

    public Double leaderReplicaBalancePercentage() {
        return this.leaderReplicaBalancePercentage;
    }

    public Double topicReplicaBalancePercentage() {
        return this.topicReplicaBalancePercentage;
    }

    public Double goalViolationDistributionThresholdMultiplier() {
        return this.goalViolationDistributionThresholdMultiplier;
    }

    public double resourceBalancePercentage(Resource resource) {
        return this.resourceBalancePercentage.get((Object)resource);
    }

    public double allowedCapacityForBroker(Resource resource, Capacity capacity) {
        return this.allowedCapacityForBroker(resource, capacity.totalCapacityFor(resource));
    }

    public double allowedCapacityForBroker(Resource resource, double totalCapacity) {
        if (totalCapacity <= 0.0) {
            return totalCapacity;
        }
        if (resource == Resource.DISK) {
            return this.allowedDiskCapacityForBroker(totalCapacity);
        }
        return this.allowedCapacity(resource, totalCapacity);
    }

    public double desiredCapacityForBroker(Resource resource, Capacity capacity) {
        double allowedCapacity = this.allowedCapacityForBroker(resource, capacity);
        if (allowedCapacity <= 0.0) {
            return allowedCapacity;
        }
        double totalCapacity = capacity.totalCapacityFor(resource);
        double desiredDelta = this.capacityBalanceDeltaThreshold * totalCapacity;
        double desiredCapacity = allowedCapacity - desiredDelta;
        if (desiredCapacity < 0.0) {
            String errMsg = String.format("The computed desired capacity cannot be negative but was computed as such - %,.2f (total capacity: %,.2f allowed capacity: %,.2f desired balance delta: %,.2f (%,.2f %%)))", desiredCapacity, totalCapacity, allowedCapacity, desiredDelta, this.capacityBalanceDeltaThreshold * 100.0);
            throw new IllegalArgumentException(errMsg);
        }
        return desiredCapacity;
    }

    public double lowUtilizationThreshold(Resource resource, OptimizationOptions options) {
        return options.isTriggeredByGoalViolation() ? this.lowUtilizationThreshold.get((Object)resource) : 0.0;
    }

    public double hotPartitionUtilizationThreshold() {
        return this.hotPartitionResourceThresholdPercentage;
    }

    private void setBalancePercentageFor(Resource resource, double balancePercentage) {
        if (balancePercentage < 1.0) {
            throw new IllegalArgumentException("Balance Percentage cannot be less than 1.0");
        }
        this.resourceBalancePercentage.put(resource, balancePercentage);
    }

    public void setResourceBalancePercentage(double resourceBalancePercentage) {
        for (Resource resource : this.resources) {
            this.setBalancePercentageFor(resource, resourceBalancePercentage);
        }
    }

    private void setCapacityThresholdFor(Resource resource, double capacityThreshold) {
        if (capacityThreshold <= 0.0 || capacityThreshold > 1.0) {
            throw new IllegalArgumentException("Capacity Threshold must be in (0, 1].");
        }
        this.capacityThreshold.put(resource, capacityThreshold);
    }

    public void setCapacityThreshold(double capacityThreshold) {
        for (Resource resource : this.resources) {
            this.setCapacityThresholdFor(resource, capacityThreshold);
        }
    }

    private void setLowUtilizationThresholdFor(Resource resource, double lowUtilizationThreshold) {
        if (lowUtilizationThreshold < 0.0 || lowUtilizationThreshold > 1.0) {
            throw new IllegalArgumentException("Low utilization threshold must be in [0, 1].");
        }
        this.lowUtilizationThreshold.put(resource, lowUtilizationThreshold);
    }

    void setLowUtilizationThreshold(double lowUtilizationThreshold) {
        for (Resource resource : this.resources) {
            this.setLowUtilizationThresholdFor(resource, lowUtilizationThreshold);
        }
    }

    private double allowedDiskCapacityForBroker(double totalDiskCapacityMiB) {
        double maxUtilizedDiskSpaceMiB = totalDiskCapacityMiB - this.minFreeDiskSpaceMiBPerBroker;
        if (maxUtilizedDiskSpaceMiB < 0.0) {
            String errMsg = String.format("Total capacity %f MiB is less than the minimum amount of free space %f MiB.", totalDiskCapacityMiB, this.minFreeDiskSpaceMiBPerBroker);
            throw new IllegalArgumentException(errMsg);
        }
        return Math.min(this.allowedCapacity(Resource.DISK, totalDiskCapacityMiB), maxUtilizedDiskSpaceMiB);
    }

    private double allowedCapacity(Resource resource, double totalCapacity) {
        return totalCapacity * this.capacityThreshold(resource);
    }

    private double capacityThreshold(Resource resource) {
        return this.capacityThreshold.get((Object)resource);
    }

    public String toString() {
        String balancePercentageStr = String.format("cpuBalancePercentage=%.4f,diskBalancePercentage=%.4f,inboundNwBalancePercentage=%.4f,inboundProducerBalancePercentage=%.4f,outboundNwBalancePercentage=%.4f", this.resourceBalancePercentage.get((Object)Resource.CPU), this.resourceBalancePercentage.get((Object)Resource.DISK), this.resourceBalancePercentage.get((Object)Resource.NW_IN), this.resourceBalancePercentage.get((Object)Resource.PRODUCE_IN), this.resourceBalancePercentage.get((Object)Resource.NW_OUT));
        String capacityThresholdStr = String.format("cpuCapacityThreshold=%.4f,diskCapacityThreshold=%.4f,inboundNwCapacityThreshold=%.4f,inboundProducerCapacityThreshold=%.4f,outboundNwCapacityThreshold=%.4f", this.capacityThreshold.get((Object)Resource.CPU), this.capacityThreshold.get((Object)Resource.DISK), this.capacityThreshold.get((Object)Resource.NW_IN), this.capacityThreshold.get((Object)Resource.PRODUCE_IN), this.capacityThreshold.get((Object)Resource.NW_OUT));
        String lowUsageThresholdStr = String.format("lowCpuUsageThreshold=%.4f,lowDiskUsageThreshold=%.4f,lowInboundNwUsageThreshold=%.4f,lowInboundProducerUsageThreshold=%.4f,lowOutboundNwUsageThreshold=%.4f]", this.lowUtilizationThreshold.get((Object)Resource.CPU), this.lowUtilizationThreshold.get((Object)Resource.DISK), this.lowUtilizationThreshold.get((Object)Resource.NW_IN), this.lowUtilizationThreshold.get((Object)Resource.PRODUCE_IN), this.lowUtilizationThreshold.get((Object)Resource.NW_OUT));
        String miscellaneousThresholdStr = String.format("maxReplicasPerBroker=%d,replicaBalancePercentage=%.4f,leaderReplicaBalancePercentage=%.4f,topicReplicaBalancePercentage=%.4f,goalViolationDistributionThresholdMultiplier=%.4f,", this.maxReplicasPerBroker, this.replicaBalancePercentage, this.leaderReplicaBalancePercentage, this.topicReplicaBalancePercentage, this.goalViolationDistributionThresholdMultiplier);
        return String.format("BalancingConstraint[%s,%s,%s,%s]", balancePercentageStr, capacityThresholdStr, miscellaneousThresholdStr, lowUsageThresholdStr);
    }
}

