/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.TopicPartition;

@Immutable
public final class GoalOptimizationHistoryOptions {
    private final long historyEpoch;
    private final long topicPartitionMovementExpirationMs;
    private final Set<TopicPartition> suspendedTopicPartitions;

    private GoalOptimizationHistoryOptions(long historyEpoch, long topicPartitionMovementExpirationMs, Set<TopicPartition> suspendedTopicPartitions) {
        this.historyEpoch = historyEpoch;
        this.topicPartitionMovementExpirationMs = topicPartitionMovementExpirationMs;
        this.suspendedTopicPartitions = suspendedTopicPartitions;
    }

    public static GoalOptimizationHistoryOptions of(long historyEpoch, long topicPartitionMovementExpirationMs, Set<TopicPartition> suspendedTopicPartitions) {
        return new GoalOptimizationHistoryOptions(historyEpoch, topicPartitionMovementExpirationMs, suspendedTopicPartitions);
    }

    public long historyEpoch() {
        return this.historyEpoch;
    }

    public long topicPartitionMovementExpirationMs() {
        return this.topicPartitionMovementExpirationMs;
    }

    public Set<TopicPartition> suspendedTopicPartitions() {
        return this.suspendedTopicPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GoalOptimizationHistoryOptions)) {
            return false;
        }
        GoalOptimizationHistoryOptions that = (GoalOptimizationHistoryOptions)o;
        return this.historyEpoch == that.historyEpoch && this.topicPartitionMovementExpirationMs == that.topicPartitionMovementExpirationMs && this.suspendedTopicPartitions.equals(that.suspendedTopicPartitions);
    }

    public int hashCode() {
        int result = Long.hashCode(this.historyEpoch);
        result = 31 * result + Long.hashCode(this.topicPartitionMovementExpirationMs);
        for (TopicPartition suspendedTopicPartition : this.suspendedTopicPartitions) {
            result = 31 * result + suspendedTopicPartition.hashCode();
        }
        return result;
    }

    public String toString() {
        return "GoalOptimizationHistoryOptions{historyEpoch=" + this.historyEpoch + ", topicPartitionMovementExpirationMs=" + this.topicPartitionMovementExpirationMs + ", suspendedTopicPartitions=" + this.suspendedTopicPartitions + '}';
    }
}

