/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.executor.ExecutionProposal;
import java.util.Set;

public class OptimizerResultReplicaMovements {
    private final int numInterBrokerReplicaMovements;
    private final long interBrokerDataToMove;
    private final int numIntraBrokerReplicaMovements;
    private final long intraBrokerDataToMove;
    private final int numLeadershipMovements;

    public OptimizerResultReplicaMovements(Set<ExecutionProposal> executionProposals) {
        int numInterBrokerReplicaMovements = 0;
        int numIntraBrokerReplicaMovements = 0;
        int numLeadershipMovements = 0;
        long interBrokerDataToMove = 0L;
        long intraBrokerDataToMove = 0L;
        for (ExecutionProposal p : executionProposals) {
            if (!p.replicasToAdd().isEmpty() || !p.replicasToRemove().isEmpty()) {
                ++numInterBrokerReplicaMovements;
                interBrokerDataToMove += p.interBrokerDataToMoveInMB();
                continue;
            }
            if (!p.replicasToMoveBetweenDisksByBroker().isEmpty()) {
                numIntraBrokerReplicaMovements += p.replicasToMoveBetweenDisksByBroker().size();
                intraBrokerDataToMove += p.intraBrokerDataToMoveInMB() * (long)p.replicasToMoveBetweenDisksByBroker().size();
                continue;
            }
            ++numLeadershipMovements;
        }
        this.numInterBrokerReplicaMovements = numInterBrokerReplicaMovements;
        this.numIntraBrokerReplicaMovements = numIntraBrokerReplicaMovements;
        this.numLeadershipMovements = numLeadershipMovements;
        this.interBrokerDataToMove = interBrokerDataToMove;
        this.intraBrokerDataToMove = intraBrokerDataToMove;
    }

    public int numInterBrokerReplicaMovements() {
        return this.numInterBrokerReplicaMovements;
    }

    public long interBrokerDataToMove() {
        return this.interBrokerDataToMove;
    }

    public int numIntraBrokerReplicaMovements() {
        return this.numIntraBrokerReplicaMovements;
    }

    public long intraBrokerDataToMove() {
        return this.intraBrokerDataToMove;
    }

    public int numLeadershipMovements() {
        return this.numLeadershipMovements;
    }
}

