/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalBalancingActionAcceptance;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;

public class ReplicaBalancingAction
implements BalancingAction {
    private static final String TOPIC_PARTITION = "topicPartition";
    private static final String SOURCE_BROKER_ID = "sourceBrokerId";
    private static final String SOURCE_BROKER_LOGDIR = "sourceBrokerLogdir";
    private static final String DESTINATION_BROKER_ID = "destinationBrokerId";
    private static final String DESTINATION_BROKER_LOGIR = "destinationBrokerLogdir";
    private static final String DESTINATION_TOPIC_PARTITION = "destinationTopicPartition";
    private static final String ACTION_TYPE = "actionType";
    private final TopicPartition tp;
    private final Integer sourceBrokerId;
    private final String sourceBrokerLogdir;
    private final String destinationBrokerLogdir;
    private final Integer destinationBrokerId;
    private final ActionType actionType;
    private final TopicPartition destinationTp;

    public ReplicaBalancingAction(TopicPartition tp, Integer sourceBrokerId, Integer destinationBrokerId, ActionType actionType) {
        this(tp, sourceBrokerId, destinationBrokerId, actionType, tp);
    }

    public ReplicaBalancingAction(TopicPartition sourceTp, Integer sourceBrokerId, Integer destinationBrokerId, ActionType actionType, TopicPartition destinationTp) {
        this(sourceTp, sourceBrokerId, null, destinationBrokerId, null, actionType, destinationTp);
    }

    public ReplicaBalancingAction(TopicPartition tp, Disk sourceDisk, Disk destinationDisk, ActionType actionType) {
        this(tp, sourceDisk.broker().id(), sourceDisk.logDir(), destinationDisk.broker().id(), destinationDisk.logDir(), actionType, tp);
    }

    public ReplicaBalancingAction(TopicPartition sourceTp, Disk sourceDisk, Disk destinationDisk, ActionType actionType, TopicPartition destinationTp) {
        this(sourceTp, sourceDisk.broker().id(), sourceDisk.logDir(), destinationDisk.broker().id(), destinationDisk.logDir(), actionType, destinationTp);
    }

    private ReplicaBalancingAction(TopicPartition sourceTp, Integer sourceBrokerId, String sourceBrokerLogdir, Integer destinationBrokerId, String destinationBrokerLogdir, ActionType actionType, TopicPartition destinationTp) {
        this.tp = sourceTp;
        this.sourceBrokerId = sourceBrokerId;
        this.sourceBrokerLogdir = sourceBrokerLogdir;
        this.destinationBrokerId = destinationBrokerId;
        this.destinationBrokerLogdir = destinationBrokerLogdir;
        this.actionType = actionType;
        this.destinationTp = destinationTp;
        this.validate();
    }

    private void validate() {
        switch (this.actionType) {
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case LEADERSHIP_MOVEMENT: 
            case INTER_BROKER_REPLICA_SWAP: {
                if (this.destinationBrokerId == null) {
                    throw new IllegalArgumentException("The destination broker cannot be null for balancing action " + this);
                }
                if (this.sourceBrokerId != null) break;
                throw new IllegalArgumentException("The source broker cannot be null for balancing action " + this);
            }
            case INTRA_BROKER_REPLICA_MOVEMENT: 
            case INTRA_BROKER_REPLICA_SWAP: {
                if (this.destinationBrokerId == null) {
                    throw new IllegalArgumentException("The destination broker cannot be null for balancing action " + this);
                }
                if (this.sourceBrokerId == null) {
                    throw new IllegalArgumentException("The source broker cannot be null for balancing action " + this);
                }
                if (this.sourceBrokerLogdir == null) {
                    throw new IllegalArgumentException("The source disk cannot be null for balancing action " + this);
                }
                if (this.destinationBrokerLogdir == null) {
                    throw new IllegalArgumentException("The destination disk cannot be null for balancing action " + this);
                }
                if (this.sourceBrokerId.equals(this.destinationBrokerId)) break;
                throw new IllegalArgumentException("Replica movement between disks across broker is not supported for balancing action " + this);
            }
            default: {
                throw new IllegalStateException("Should never be here");
            }
        }
    }

    public TopicPartition destinationTopicPartition() {
        return this.destinationTp;
    }

    public String destinationTopic() {
        return this.destinationTp.topic();
    }

    public int partitionId() {
        return this.tp.partition();
    }

    public String topic() {
        return this.tp.topic();
    }

    @Override
    public TopicPartition topicPartition() {
        return this.tp;
    }

    public String sourceBrokerLogdir() {
        return this.sourceBrokerLogdir;
    }

    public String destinationBrokerLogdir() {
        return this.destinationBrokerLogdir;
    }

    public Integer sourceBrokerId() {
        return this.sourceBrokerId;
    }

    public Integer destinationBrokerId() {
        return this.destinationBrokerId;
    }

    @Override
    public ActionType balancingAction() {
        return this.actionType;
    }

    @Override
    public ActionAcceptance actionAcceptance(GoalBalancingActionAcceptance actionAcceptance, ClusterModel clusterModel) {
        return actionAcceptance.replicaActionAcceptance(this, clusterModel);
    }

    @Override
    public boolean selfSatisfied(ClusterModel clusterModel, GoalBalancingActionAcceptance actionAcceptance) {
        return actionAcceptance.replicaActionSelfSatisfied(clusterModel, this);
    }

    @Override
    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> proposalMap = new HashMap<String, Object>();
        proposalMap.put(TOPIC_PARTITION, this.tp);
        proposalMap.put(SOURCE_BROKER_ID, this.sourceBrokerId);
        proposalMap.put(DESTINATION_BROKER_ID, this.destinationBrokerId);
        proposalMap.put(DESTINATION_TOPIC_PARTITION, this.destinationTp);
        proposalMap.put(ACTION_TYPE, (Object)this.actionType);
        if (this.sourceBrokerLogdir != null) {
            proposalMap.put(SOURCE_BROKER_LOGDIR, this.sourceBrokerLogdir);
            proposalMap.put(DESTINATION_BROKER_LOGIR, this.destinationBrokerLogdir);
        }
        return proposalMap;
    }

    public String toString() {
        String actSymbol = this.actionType.equals((Object)ActionType.INTER_BROKER_REPLICA_SWAP) || this.actionType.equals((Object)ActionType.INTRA_BROKER_REPLICA_SWAP) ? "<->" : "->";
        return String.format("(%s%s%s, %d%s%s%d%s, %s)", new Object[]{this.tp, actSymbol, this.destinationTp, this.sourceBrokerId, this.sourceBrokerLogdir == null ? "" : String.format("(%s)", this.sourceBrokerLogdir), actSymbol, this.destinationBrokerId, this.destinationBrokerLogdir == null ? "" : String.format("(%s)", this.destinationBrokerLogdir), this.actionType});
    }

    public boolean equals(Object other) {
        if (!(other instanceof ReplicaBalancingAction)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        ReplicaBalancingAction otherAction = (ReplicaBalancingAction)other;
        return Objects.equals(this.sourceBrokerId, otherAction.sourceBrokerId) && Objects.equals(this.sourceBrokerLogdir, otherAction.sourceBrokerLogdir) && Objects.equals(this.tp, otherAction.tp) && Objects.equals(this.destinationBrokerId, otherAction.destinationBrokerId) && Objects.equals(this.destinationBrokerLogdir, otherAction.destinationBrokerLogdir) && Objects.equals(this.destinationTp, otherAction.destinationTp) && Objects.equals((Object)this.actionType, (Object)otherAction.actionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tp, this.sourceBrokerId, this.sourceBrokerLogdir, this.destinationBrokerId, this.destinationBrokerLogdir, this.actionType, this.destinationTp});
    }
}

