/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import java.util.Objects;

public class DistributionThresholdUtils {
    public static final double BALANCE_MARGIN = 0.9;

    public static double clusterUtilizationAverage(ClusterModel clusterModel, Resource resource) {
        return clusterModel.expectedUtilizationInEligibleSourceBrokersFor(resource) / clusterModel.eligibleDestinationCapacityFor(resource);
    }

    private static int replicaBalanceUpperLimit(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, double avgReplicasOnBroker, double balancePercentage) {
        double adjustedBalancePct = DistributionThresholdUtils.balancePercentageWithMargin(optimizationOptions, balancingConstraint, balancePercentage);
        return (int)Math.ceil(avgReplicasOnBroker * (1.0 + adjustedBalancePct));
    }

    private static int replicaBalanceLowerLimit(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, double avgReplicasOnBroker, double balancePercentage) {
        double adjustedBalancePct = DistributionThresholdUtils.balancePercentageWithMargin(optimizationOptions, balancingConstraint, balancePercentage);
        return (int)Math.floor(avgReplicasOnBroker * Math.max(0.0, 1.0 - adjustedBalancePct));
    }

    static double computeBalanceUpperThresholdPercentage(double utilizationPercentage, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource) {
        return Math.min(1.0, utilizationPercentage * (1.0 + DistributionThresholdUtils.balancePercentageWithMargin(optimizationOptions, balancingConstraint, resource)));
    }

    private static double computeBalanceLowerThresholdPercentage(double utilizationPercentage, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource) {
        return utilizationPercentage * Math.max(0.0, 1.0 - DistributionThresholdUtils.balancePercentageWithMargin(optimizationOptions, balancingConstraint, resource));
    }

    private static double balancePercentageWithMargin(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource) {
        return DistributionThresholdUtils.balancePercentageWithMargin(optimizationOptions, balancingConstraint, balancingConstraint.resourceBalancePercentage(resource));
    }

    private static double balancePercentageWithMargin(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, double resourceBalancePercentage) {
        double multiplier = optimizationOptions.isTriggeredByGoalViolation() ? balancingConstraint.goalViolationDistributionThresholdMultiplier() : 1.0;
        double balancePercentage = resourceBalancePercentage * multiplier;
        return (balancePercentage - 1.0) * 0.9;
    }

    public static class ResourcePercentageThresholds {
        private final double balanceUpperPercentThreshold;
        private final double balanceLowerPercentThreshold;
        private final double lowUtilizationPercentThreshold;
        private final double meanUtilizationPercentThreshold;
        private final Resource resource;

        private ResourcePercentageThresholds(double balanceUpperPercent, double balanceLowerPercent, double lowUtilizationPercent, double meanUtilizationPercent, Resource resource, boolean validatePercentages) {
            this.balanceUpperPercentThreshold = validatePercentages ? this.validatePercentage(balanceUpperPercent, "balance upper percentage") : balanceUpperPercent;
            this.balanceLowerPercentThreshold = validatePercentages ? this.validatePercentage(balanceLowerPercent, "balance lower percentage") : balanceLowerPercent;
            this.lowUtilizationPercentThreshold = validatePercentages ? this.validatePercentage(lowUtilizationPercent, "low utilization percentage") : lowUtilizationPercent;
            this.meanUtilizationPercentThreshold = validatePercentages ? this.validatePercentage(meanUtilizationPercent, "mean utilization percentage") : meanUtilizationPercent;
            this.resource = resource;
        }

        private double validatePercentage(double percentageValue, String percentageName) {
            if (percentageValue < 0.0 || percentageValue > 1.0) {
                throw new IllegalArgumentException(String.format("An invalid value %f was supplied for %s. Must be within the range 0.0-1.0.", percentageValue, percentageName));
            }
            return percentageValue;
        }

        public double balanceUpperPercent() {
            return this.balanceUpperPercentThreshold;
        }

        public double balanceLowerPercent() {
            return this.balanceLowerPercentThreshold;
        }

        public double lowUtilizationPercent() {
            return this.lowUtilizationPercentThreshold;
        }

        public double meanUtilizationPercent() {
            return this.meanUtilizationPercentThreshold;
        }

        public Resource resource() {
            return this.resource;
        }

        public String toString() {
            String lowUtilStr = String.format("%.2f", this.lowUtilizationPercentThreshold * 100.0) + "%";
            String meanUtilStr = String.format("%.2f", this.meanUtilizationPercentThreshold * 100.0) + "%";
            String balanceLowerThresholdStr = String.format("%.2f", this.balanceLowerPercentThreshold * 100.0) + "%";
            String balanceUpperThresholdStr = String.format("%.2f", this.balanceUpperPercentThreshold * 100.0) + "%";
            return String.format("Resource Percentage Thresholds for %s - low utilization %s, mean utilization - %s, lower and upper limits - %s and %s", this.resource.resource(), lowUtilStr, meanUtilStr, balanceLowerThresholdStr, balanceUpperThresholdStr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourcePercentageThresholds that = (ResourcePercentageThresholds)o;
            return Double.compare(that.balanceUpperPercentThreshold, this.balanceUpperPercentThreshold) == 0 && Double.compare(that.balanceLowerPercentThreshold, this.balanceLowerPercentThreshold) == 0 && Double.compare(that.lowUtilizationPercentThreshold, this.lowUtilizationPercentThreshold) == 0 && Double.compare(that.meanUtilizationPercentThreshold, this.meanUtilizationPercentThreshold) == 0 && this.resource == that.resource;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.balanceUpperPercentThreshold, this.balanceLowerPercentThreshold, this.lowUtilizationPercentThreshold, this.meanUtilizationPercentThreshold, this.resource});
        }

        public static ResourcePercentageThresholds compute(ClusterModel clusterModel, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource, boolean validatePercentages) {
            double clusterUtilizationPercentage = DistributionThresholdUtils.clusterUtilizationAverage(clusterModel, resource);
            return new ResourcePercentageThresholds(DistributionThresholdUtils.computeBalanceUpperThresholdPercentage(clusterUtilizationPercentage, optimizationOptions, balancingConstraint, resource), DistributionThresholdUtils.computeBalanceLowerThresholdPercentage(clusterUtilizationPercentage, optimizationOptions, balancingConstraint, resource), balancingConstraint.lowUtilizationThreshold(resource, optimizationOptions), clusterUtilizationPercentage, resource, validatePercentages);
        }
    }

    public static class ReplicaThresholds {
        public final int numReplicasUpperLimit;
        public final int numReplicasLowerLimit;

        public ReplicaThresholds(int numReplicasUpperLimit, int numReplicasLowerLimit) {
            this.numReplicasUpperLimit = numReplicasUpperLimit;
            this.numReplicasLowerLimit = numReplicasLowerLimit;
        }

        public static ReplicaThresholds compute(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, double avgReplicasOnBroker, double balancePercentage) {
            return new ReplicaThresholds(DistributionThresholdUtils.replicaBalanceUpperLimit(optimizationOptions, balancingConstraint, avgReplicasOnBroker, balancePercentage), DistributionThresholdUtils.replicaBalanceLowerLimit(optimizationOptions, balancingConstraint, avgReplicasOnBroker, balancePercentage));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicaThresholds that = (ReplicaThresholds)o;
            return this.numReplicasUpperLimit == that.numReplicasUpperLimit && this.numReplicasLowerLimit == that.numReplicasLowerLimit;
        }

        public int hashCode() {
            return Objects.hash(this.numReplicasUpperLimit, this.numReplicasLowerLimit);
        }

        public String toString() {
            return "ReplicaThresholds{numReplicasUpperLimit=" + this.numReplicasUpperLimit + ", numReplicasLowerLimit=" + this.numReplicasLowerLimit + "}";
        }
    }
}

