/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.ProposalStats;
import io.confluent.cruisecontrol.analyzer.history.TopicPartitionMovement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class GoalOptimizationResult {
    private final boolean succeeded;
    private final boolean hasReplicaChange;
    private final Set<String> movementsFrom;
    private final ProposalStats proposalStats;
    private final SortedSet<TopicPartitionMovement> topicPartitionMovements;

    private GoalOptimizationResult(boolean succeeded, boolean hasReplicaMove, Set<String> movementsFrom, ProposalStats proposalStats, SortedSet<TopicPartitionMovement> topicPartitionMovements) {
        this.succeeded = succeeded;
        this.hasReplicaChange = hasReplicaMove;
        this.movementsFrom = new HashSet<String>(movementsFrom);
        this.proposalStats = proposalStats;
        this.topicPartitionMovements = topicPartitionMovements;
    }

    public boolean hasReplicaChange() {
        return this.hasReplicaChange;
    }

    public boolean isSuccesful() {
        return this.succeeded;
    }

    public Set<String> goalsWithMovements() {
        return Collections.unmodifiableSet(this.movementsFrom);
    }

    public ProposalStats proposalStats() {
        return this.proposalStats;
    }

    public SortedSet<TopicPartitionMovement> topicPartitionMovements() {
        return this.topicPartitionMovements;
    }

    public String toString() {
        return "GoalOptimizationResult{succeeded=" + this.succeeded + ", hasReplicaChange=" + this.hasReplicaChange + ", movementsFrom=" + this.movementsFrom + ", proposalStats=" + this.proposalStats + ", topicPartitionMovements=" + this.topicPartitionMovements + '}';
    }

    public static class Builder {
        private boolean succeeded = true;
        private boolean hasReplicaChange;
        private final Set<String> movementsFrom = new HashSet<String>();
        private ProposalStats proposalStats;
        private SortedSet<TopicPartitionMovement> topicPartitionMovements = new TreeSet<TopicPartitionMovement>();

        public Builder markUnsuccessfulOptimization() {
            this.succeeded = false;
            return this;
        }

        public Builder recordReplicaChange(String goalKlass) {
            this.hasReplicaChange = true;
            this.movementsFrom.add(goalKlass);
            return this;
        }

        public Builder proposalStats(ProposalStats newStats) {
            this.proposalStats = newStats;
            return this;
        }

        public Builder recordTopicPartitionMovement(TopicPartitionMovement topicPartitionMovement) {
            this.topicPartitionMovements.add(topicPartitionMovement);
            return this;
        }

        public GoalOptimizationResult build() {
            return new GoalOptimizationResult(this.succeeded, this.hasReplicaChange, this.movementsFrom, this.proposalStats, this.topicPartitionMovements);
        }
    }
}

