/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.IncrementalResourceDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ProposalObservabilityTrackingOptions;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import java.util.Map;

public class IncrementalCPUResourceDistributionGoal
extends IncrementalResourceDistributionGoal {
    private int numTopProposalsToTrack;
    private boolean topProposalTrackingEnabled = false;

    public IncrementalCPUResourceDistributionGoal() {
    }

    IncrementalCPUResourceDistributionGoal(BalancingConstraint constraint) {
        super(constraint);
    }

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        KafkaCruiseControlConfig parsedConfig = new KafkaCruiseControlConfig(configs, false);
        this.numTopProposalsToTrack = parsedConfig.getInt("incremental.balancing.cpu.top.proposal.tracking.num.proposals");
        this.topProposalTrackingEnabled = parsedConfig.getBoolean("incremental.balancing.cpu.top.proposal.tracking.enabled");
    }

    @Override
    protected Resource resource() {
        return Resource.CPU;
    }

    @Override
    protected boolean validatePercentages() {
        return false;
    }

    @Override
    protected ProposalObservabilityTrackingOptions proposalTrackingOptions() {
        return new ProposalObservabilityTrackingOptions(this.topProposalTrackingEnabled, this.numTopProposalsToTrack);
    }
}

