/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ChainReplicaFilter;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.EntityFilter;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ResourceDistributionGoal;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.function.Predicate;

public class NetworkOutboundUsageDistributionGoal
extends ResourceDistributionGoal {
    public NetworkOutboundUsageDistributionGoal() {
    }

    NetworkOutboundUsageDistributionGoal(BalancingConstraint constraint) {
        super(constraint);
    }

    @Override
    protected EntityFilter<Replica> replicaFilter() {
        Predicate<Replica> isLeader = Replica::isLeader;
        Predicate<Replica> hasNonZeroUtilization = replica -> AnalyzerUtils.isLarger(replica.load().expectedUtilizationFor(this.resource()), 0.0);
        return new ChainReplicaFilter(isLeader.or(hasNonZeroUtilization));
    }

    @Override
    protected Resource resource() {
        return Resource.NW_OUT;
    }

    @Override
    public String name() {
        return NetworkOutboundUsageDistributionGoal.class.getSimpleName();
    }
}

