/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicReplicaDistributionGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(TopicReplicaDistributionGoal.class);
    private static final double BALANCE_MARGIN = 0.9;
    private boolean fixOfflineReplicasOnly;
    private final Map<String, Set<Integer>> brokerIdsAboveBalanceUpperLimitByTopic = new HashMap<String, Set<Integer>>();
    private final Map<String, Set<Integer>> brokerIdsUnderBalanceLowerLimitByTopic = new HashMap<String, Set<Integer>>();
    private final Map<String, Double> avgTopicReplicasOnEligibleDestinationBroker = new HashMap<String, Double>();
    private final Map<String, Integer> balanceUpperLimitByTopic = new HashMap<String, Integer>();
    private final Map<String, Integer> balanceLowerLimitByTopic = new HashMap<String, Integer>();

    public TopicReplicaDistributionGoal() {
    }

    public TopicReplicaDistributionGoal(BalancingConstraint balancingConstraint) {
        this();
        this.balancingConstraint = balancingConstraint;
    }

    double balancePercentageWithMargin(OptimizationOptions optimizationOptions) {
        double balancePercentage = optimizationOptions.isTriggeredByGoalViolation() ? this.balancingConstraint.topicReplicaBalancePercentage() * this.balancingConstraint.goalViolationDistributionThresholdMultiplier() : this.balancingConstraint.topicReplicaBalancePercentage();
        return (balancePercentage - 1.0) * 0.9;
    }

    int balanceUpperLimit(String topic, OptimizationOptions optimizationOptions) {
        return (int)Math.ceil(this.avgTopicReplicasOnEligibleDestinationBroker.get(topic) * (1.0 + this.balancePercentageWithMargin(optimizationOptions)));
    }

    int balanceLowerLimit(String topic, OptimizationOptions optimizationOptions) {
        return (int)Math.floor(this.avgTopicReplicasOnEligibleDestinationBroker.get(topic) * Math.max(0.0, 1.0 - this.balancePercentageWithMargin(optimizationOptions)));
    }

    double avgTopicReplicasOnEligibleDestinationBroker(String topic) {
        return this.avgTopicReplicasOnEligibleDestinationBroker.get(topic);
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String sourceTopic = action.topic();
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: {
                String destinationTopic = action.destinationTopic();
                if (sourceTopic.equals(destinationTopic)) {
                    return ActionAcceptance.ACCEPT;
                }
                boolean acceptSourceToDest = this.isReplicaCountUnderBalanceUpperLimitAfterChange(sourceTopic, destinationBroker, ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceTopic, sourceBroker, ReplicaDistributionAbstractGoal.ChangeType.REMOVE);
                return acceptSourceToDest && this.isReplicaCountUnderBalanceUpperLimitAfterChange(destinationTopic, sourceBroker, ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(destinationTopic, destinationBroker, ReplicaDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: {
                return this.isReplicaCountUnderBalanceUpperLimitAfterChange(sourceTopic, destinationBroker, ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceTopic, sourceBroker, ReplicaDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    private boolean isReplicaCountUnderBalanceUpperLimitAfterChange(String topic, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerBalanceUpperLimit;
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("isReplicaCountUnderBalanceUpperLimitAfterChange doesn't accept ignored broker as input.");
        }
        int numTopicReplicas = broker.numReplicasOfTopicInBroker(topic);
        int n = brokerBalanceUpperLimit = broker.isAlive() ? this.balanceUpperLimitByTopic.get(topic) : 0;
        return changeType == ReplicaDistributionAbstractGoal.ChangeType.ADD ? numTopicReplicas + 1 <= brokerBalanceUpperLimit : numTopicReplicas - 1 <= brokerBalanceUpperLimit;
    }

    private boolean isReplicaCountAboveBalanceLowerLimitAfterChange(String topic, Broker broker, ReplicaDistributionAbstractGoal.ChangeType changeType) {
        int brokerBalanceLowerLimit;
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("isReplicaCountAboveBalanceUpperLimitAfterChange doesn't accept ignored broker as input.");
        }
        int numTopicReplicas = broker.numReplicasOfTopicInBroker(topic);
        int n = brokerBalanceLowerLimit = broker.isAlive() ? this.balanceLowerLimitByTopic.get(topic) : 0;
        return changeType == ReplicaDistributionAbstractGoal.ChangeType.ADD ? numTopicReplicas + 1 >= brokerBalanceLowerLimit : numTopicReplicas - 1 >= brokerBalanceLowerLimit;
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new TopicReplicaDistrGoalStatsComparator();
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true);
    }

    @Override
    public String name() {
        return TopicReplicaDistributionGoal.class.getSimpleName();
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.eligibleSourceOrDestinationBrokers();
    }

    private Set<String> topicsToRebalance(ClusterModel clusterModel, Set<String> excludedTopics) {
        HashSet<Object> topicsToRebalance;
        if (!clusterModel.selfHealingEligibleReplicas().isEmpty()) {
            topicsToRebalance = new HashSet();
            for (Replica replica : clusterModel.selfHealingEligibleReplicas()) {
                topicsToRebalance.add(replica.topicPartition().topic());
            }
        } else {
            topicsToRebalance = new HashSet<String>(clusterModel.topics());
            topicsToRebalance.removeAll(excludedTopics);
        }
        if (topicsToRebalance.isEmpty()) {
            LOG.warn("All topics are excluded from {}.", (Object)this.name());
        }
        return topicsToRebalance;
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        Set<String> topicsToRebalance = this.topicsToRebalance(clusterModel, optimizationOptions.excludedTopics());
        for (String topic : clusterModel.topics()) {
            int numTopicReplicasInEligibleSourceBrokers = clusterModel.numTopicReplicasOnEligibleSourceBrokers(topic);
            this.avgTopicReplicasOnEligibleDestinationBroker.put(topic, (double)numTopicReplicasInEligibleSourceBrokers / (double)clusterModel.eligibleDestinationBrokers().size());
            this.balanceUpperLimitByTopic.put(topic, this.balanceUpperLimit(topic, optimizationOptions));
            this.balanceLowerLimitByTopic.put(topic, this.balanceLowerLimit(topic, optimizationOptions));
            if (topicsToRebalance.contains(topic)) continue;
            this.avgTopicReplicasOnEligibleDestinationBroker.remove(topic);
        }
        this.fixOfflineReplicasOnly = false;
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        if (this.fixOfflineReplicasOnly && sourceBroker.replica(action.topicPartition()).isCurrentOffline()) {
            return action.balancingAction() == ActionType.INTER_BROKER_REPLICA_MOVEMENT;
        }
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        String sourceTopic = action.topic();
        return this.isReplicaCountUnderBalanceUpperLimitAfterChange(sourceTopic, destinationBroker, ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceTopic, sourceBroker, ReplicaDistributionAbstractGoal.ChangeType.REMOVE);
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        if (!this.brokerIdsAboveBalanceUpperLimitByTopic.isEmpty()) {
            this.brokerIdsAboveBalanceUpperLimitByTopic.clear();
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
        if (!this.brokerIdsUnderBalanceLowerLimitByTopic.isEmpty()) {
            this.brokerIdsUnderBalanceLowerLimitByTopic.clear();
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
        try {
            GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        }
        catch (OptimizationFailureException ofe) {
            if (this.fixOfflineReplicasOnly) {
                throw ofe;
            }
            this.fixOfflineReplicasOnly = true;
            LOG.info("Ignoring topic replica balance limit to move replicas from dead brokers/disks.");
            return;
        }
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        this.finish();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    private static boolean skipBrokerRebalance(Broker broker, ClusterModel clusterModel, Collection<Replica> replicas, boolean requireLessReplicas, boolean requireMoreReplicas, boolean hasOfflineTopicReplicas) {
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("skipBrokerRebalance doesn't accept ignored broker as input.");
        }
        boolean hasImmigrantTopicReplicas = replicas.stream().anyMatch(replica -> broker.immigrantReplicas().contains(replica));
        if (broker.isAlive() && !requireMoreReplicas && !requireLessReplicas) {
            LOG.trace("Skip rebalance: Broker {} is already within the limit for replicas {}.", (Object)broker, replicas);
            return true;
        }
        if (!(clusterModel.newBrokers().isEmpty() || broker.isNew() || requireLessReplicas)) {
            LOG.trace("Skip rebalance: Cluster has new brokers and this broker {} is not new, but does not require less load for replicas {}. Hence, it does not have any offline replicas.", (Object)broker, replicas);
            return true;
        }
        if (!clusterModel.selfHealingEligibleReplicas().isEmpty() && requireLessReplicas && !hasOfflineTopicReplicas && !hasImmigrantTopicReplicas) {
            LOG.trace("Skip rebalance: Cluster is in self-healing mode and the broker {} requires less load, but none of its current offline or immigrant replicas are from the topic being balanced {}.", (Object)broker, replicas);
            return true;
        }
        return false;
    }

    private static Set<Replica> retainCurrentOfflineBrokerReplicas(Broker broker, Collection<Replica> replicas) {
        HashSet<Replica> offlineReplicas = new HashSet<Replica>(replicas);
        offlineReplicas.retainAll(broker.currentOfflineReplicas());
        return offlineReplicas;
    }

    private boolean isTopicExcludedFromRebalance(String topic) {
        return this.avgTopicReplicasOnEligibleDestinationBroker.get(topic) == null;
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        LOG.debug("Rebalancing broker {} [limits] lower: {} upper: {}.", new Object[]{broker.id(), this.balanceLowerLimitByTopic, this.balanceUpperLimitByTopic});
        for (String topic : broker.topics()) {
            boolean requireMoreReplicas;
            if (this.isTopicExcludedFromRebalance(topic)) continue;
            Collection<Replica> replicas = broker.replicasOfTopicInBroker(topic);
            int numTopicReplicas = replicas.size();
            int numOfflineTopicReplicas = TopicReplicaDistributionGoal.retainCurrentOfflineBrokerReplicas(broker, replicas).size();
            boolean requireLessReplicas = broker.isEligibleSource() && (numOfflineTopicReplicas > 0 || numTopicReplicas > this.balanceUpperLimitByTopic.get(topic));
            if (TopicReplicaDistributionGoal.skipBrokerRebalance(broker, clusterModel, replicas, requireLessReplicas, requireMoreReplicas = broker.isEligibleDestination() && numTopicReplicas - numOfflineTopicReplicas < this.balanceLowerLimitByTopic.get(topic), numOfflineTopicReplicas > 0)) continue;
            if (requireLessReplicas && this.rebalanceByMovingReplicasOut(broker, topic, clusterModel, optimizedGoals, optimizationOptions)) {
                this.brokerIdsAboveBalanceUpperLimitByTopic.computeIfAbsent(topic, t -> new HashSet()).add(broker.id());
                LOG.debug("Failed to sufficiently decrease replicas of topic {} in broker {} with replica movements. Replicas: {}.", new Object[]{topic, broker.id(), broker.numReplicasOfTopicInBroker(topic)});
            }
            if (requireMoreReplicas && this.rebalanceByMovingReplicasIn(broker, topic, clusterModel, optimizedGoals, optimizationOptions)) {
                this.brokerIdsUnderBalanceLowerLimitByTopic.computeIfAbsent(topic, t -> new HashSet()).add(broker.id());
                LOG.debug("Failed to sufficiently increase replicas of topic {} in broker {} with replica movements. Replicas: {}.", new Object[]{topic, broker.id(), broker.numReplicasOfTopicInBroker(topic)});
            }
            if (this.brokerIdsAboveBalanceUpperLimitByTopic.getOrDefault(topic, Collections.emptySet()).contains(broker.id()) || this.brokerIdsUnderBalanceLowerLimitByTopic.getOrDefault(topic, Collections.emptySet()).contains(broker.id())) continue;
            LOG.debug("Successfully balanced replicas of topic {} in broker {} by moving replicas. Replicas: {}", new Object[]{topic, broker.id(), broker.numReplicasOfTopicInBroker(topic)});
        }
    }

    private static SortedSet<Replica> replicasToMoveOut(ClusterModel clusterModel, Broker broker, String topic) {
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("replicasToMoveOut doesn't accept ignored broker as input.");
        }
        TreeSet<Replica> replicasToMoveOut = new TreeSet<Replica>(broker.replicaComparator());
        replicasToMoveOut.addAll(broker.replicasOfTopicInBroker(topic));
        if (!clusterModel.brokenBrokers().isEmpty() && broker.isAlive()) {
            for (Replica replica : replicasToMoveOut) {
                if (broker.currentOfflineReplicas().contains(replica) || broker.immigrantReplicas().contains(replica)) continue;
                return replicasToMoveOut.subSet((Replica)replicasToMoveOut.first(), replica);
            }
        }
        return replicasToMoveOut;
    }

    boolean rebalanceByMovingReplicasOut(Broker broker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        TreeSet<Broker> candidateBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.numReplicasOfTopicInBroker(topic)).thenComparingInt(Broker::id));
        candidateBrokers.addAll(this.fixOfflineReplicasOnly ? clusterModel.eligibleDestinationBrokers() : (Collection)clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.numReplicasOfTopicInBroker(topic) < this.balanceUpperLimitByTopic.get(topic)).collect(Collectors.toSet()));
        Collection<Replica> replicasOfTopicInBroker = broker.replicasOfTopicInBroker(topic);
        int numReplicasOfTopicInBroker = replicasOfTopicInBroker.size();
        int numOfflineTopicReplicas = TopicReplicaDistributionGoal.retainCurrentOfflineBrokerReplicas(broker, replicasOfTopicInBroker).size();
        boolean wasUnableToMoveOfflineReplica = false;
        for (Replica replica : TopicReplicaDistributionGoal.replicasToMoveOut(clusterModel, broker, topic)) {
            if (wasUnableToMoveOfflineReplica && !replica.isCurrentOffline() && numReplicasOfTopicInBroker <= this.balanceUpperLimitByTopic.get(topic)) {
                return false;
            }
            if (TopicReplicaDistributionGoal.shouldExclude(replica, excludedTopics)) continue;
            boolean wasOffline = replica.isCurrentOffline();
            Broker b2 = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty());
            if (b2 != null) {
                if (wasOffline) {
                    --numOfflineTopicReplicas;
                }
                if (--numReplicasOfTopicInBroker <= (numOfflineTopicReplicas == 0 ? this.balanceUpperLimitByTopic.get(topic) : 0)) {
                    return false;
                }
                candidateBrokers.remove(b2);
                if (b2.numReplicasOfTopicInBroker(topic) >= this.balanceUpperLimitByTopic.get(topic) && !this.fixOfflineReplicasOnly) continue;
                candidateBrokers.add(b2);
                continue;
            }
            if (!wasOffline) continue;
            wasUnableToMoveOfflineReplica = true;
        }
        return !broker.replicasOfTopicInBroker(topic).isEmpty();
    }

    boolean rebalanceByMovingReplicasIn(Broker aliveDestBroker, String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        PriorityQueue<Broker> eligibleBrokers = new PriorityQueue<Broker>((b1, b2) -> {
            Collection<Replica> replicasOfTopicInB2 = b2.replicasOfTopicInBroker(topic);
            int numReplicasOfTopicInB2 = replicasOfTopicInB2.size();
            int numOfflineTopicReplicasInB2 = TopicReplicaDistributionGoal.retainCurrentOfflineBrokerReplicas(b2, replicasOfTopicInB2).size();
            Collection<Replica> replicasOfTopicInB1 = b1.replicasOfTopicInBroker(topic);
            int numReplicasOfTopicInB1 = replicasOfTopicInB1.size();
            int numOfflineTopicReplicasInB1 = TopicReplicaDistributionGoal.retainCurrentOfflineBrokerReplicas(b2, replicasOfTopicInB1).size();
            int resultByOfflineReplicas = Integer.compare(numOfflineTopicReplicasInB2, numOfflineTopicReplicasInB1);
            if (resultByOfflineReplicas == 0) {
                int resultByAllReplicas = Integer.compare(numReplicasOfTopicInB2, numReplicasOfTopicInB1);
                return resultByAllReplicas == 0 ? Integer.compare(b1.id(), b2.id()) : resultByAllReplicas;
            }
            return resultByOfflineReplicas;
        });
        if (this.fixOfflineReplicasOnly) {
            clusterModel.eligibleSourceBrokers().stream().filter(sourceBroker -> sourceBroker.id() != aliveDestBroker.id()).forEach(eligibleBrokers::add);
        } else {
            for (Broker sourceBroker2 : clusterModel.eligibleSourceBrokers()) {
                if (sourceBroker2.numReplicasOfTopicInBroker(topic) <= this.balanceLowerLimitByTopic.get(topic) && sourceBroker2.currentOfflineReplicas().isEmpty()) continue;
                eligibleBrokers.add(sourceBroker2);
            }
        }
        Collection<Replica> replicasOfTopicInBroker = aliveDestBroker.replicasOfTopicInBroker(topic);
        int numReplicasOfTopicInBroker = replicasOfTopicInBroker.size();
        Set<Broker> candidateBrokers = Collections.singleton(aliveDestBroker);
        block1: while (!eligibleBrokers.isEmpty()) {
            Broker sourceBroker3 = (Broker)eligibleBrokers.poll();
            SortedSet<Replica> replicasToMove = TopicReplicaDistributionGoal.replicasToMoveOut(clusterModel, sourceBroker3, topic);
            int numOfflineTopicReplicas = TopicReplicaDistributionGoal.retainCurrentOfflineBrokerReplicas(sourceBroker3, replicasToMove).size();
            for (Replica replica : replicasToMove) {
                if (TopicReplicaDistributionGoal.shouldExclude(replica, excludedTopics)) continue;
                boolean wasOffline = replica.isCurrentOffline();
                Broker b = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty());
                if (b == null) continue;
                if (wasOffline) {
                    --numOfflineTopicReplicas;
                }
                if (++numReplicasOfTopicInBroker >= this.balanceLowerLimitByTopic.get(topic)) {
                    return false;
                }
                if (eligibleBrokers.isEmpty() || numOfflineTopicReplicas != 0 || sourceBroker3.numReplicasOfTopicInBroker(topic) >= ((Broker)eligibleBrokers.peek()).numReplicasOfTopicInBroker(topic)) continue;
                eligibleBrokers.add(sourceBroker3);
                continue block1;
            }
        }
        return true;
    }

    private class TopicReplicaDistrGoalStatsComparator
    implements ClusterModelStatsComparator {
        private String reasonForLastNegativeResult;

        private TopicReplicaDistrGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            double stdDev1 = stats1.topicReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            double stdDev2 = stats2.topicReplicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            int result = AnalyzerUtils.compare(stdDev2, stdDev1, 1.0E-5);
            if (result < 0) {
                this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Topic Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", TopicReplicaDistributionGoal.this.name(), stdDev1, stdDev2);
            }
            return result;
        }

        @Override
        public String explainLastComparison() {
            return this.reasonForLastNegativeResult;
        }
    }
}

