/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ReplicaDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BrokerResourceStats {
    public final double capacityValue;
    public final double utilizationValue;
    public final int brokerId;
    public final String resource;

    public BrokerResourceStats(double capacityValue, double utilizationValue, int brokerId, Resource resource) {
        this(capacityValue, utilizationValue, brokerId, resource.name());
    }

    public BrokerResourceStats(double capacityValue, double utilizationValue, int brokerId, ReplicaDistributionStatsSnapshot.ReplicaResource resource) {
        this(capacityValue, utilizationValue, brokerId, resource.name());
    }

    private BrokerResourceStats(double capacityValue, double utilizationValue, int brokerId, String resource) {
        this.capacityValue = capacityValue;
        this.utilizationValue = utilizationValue;
        this.brokerId = brokerId;
        this.resource = resource;
    }

    public double utilizationRatio() {
        return Double.compare(this.capacityValue, 0.0) > 0 ? this.utilizationValue / this.capacityValue : 1.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerResourceStats that = (BrokerResourceStats)o;
        return Double.compare(that.capacityValue, this.capacityValue) == 0 && Double.compare(that.utilizationValue, this.utilizationValue) == 0 && this.brokerId == that.brokerId && Objects.equals(this.resource, that.resource);
    }

    public int hashCode() {
        return Objects.hash(this.capacityValue, this.utilizationValue, this.brokerId, this.resource);
    }

    public String toString() {
        return "BrokerResourceStats{capacityValue=" + this.capacityValue + ", utilizationValue=" + this.utilizationValue + ", brokerId=" + this.brokerId + ", resource='" + this.resource + '\'' + "}";
    }
}

