/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.Set;
import java.util.SortedSet;

public class CandidateBroker
implements Comparable<CandidateBroker> {
    private final Broker broker;
    private final SortedSet<Replica> replicas;
    private final boolean isAscending;
    private final boolean excludedForLeadership;
    private final boolean excludedForReplicaMove;
    private final Resource resource;

    public CandidateBroker(Broker broker, Resource resource, SortedSet<Replica> replicas, boolean isAscending, Set<Integer> excludedBrokersForLeadership, Set<Integer> excludedBrokersForReplicaMove) {
        this.broker = broker;
        this.replicas = replicas;
        this.isAscending = isAscending;
        this.excludedForLeadership = excludedBrokersForLeadership.contains(this.broker.id());
        this.excludedForReplicaMove = excludedBrokersForReplicaMove.contains(this.broker.id());
        this.resource = resource;
    }

    public Broker broker() {
        return this.broker;
    }

    public SortedSet<Replica> replicas() {
        return this.replicas;
    }

    public Resource resource() {
        return this.resource;
    }

    public boolean shouldExcludeForLeadership(Replica replicaToReceive) {
        return this.excludedForLeadership && !replicaToReceive.isOriginalOffline() && replicaToReceive.isLeader();
    }

    public boolean shouldExcludeForReplicaMove(Replica replicaToReceive) {
        return this.excludedForReplicaMove && replicaToReceive.originalBroker().isAlive();
    }

    @Override
    public int compareTo(CandidateBroker o) {
        int result = this.isAscending ? Double.compare(GoalUtils.utilizationPercentage(this.broker, this.resource), GoalUtils.utilizationPercentage(o.broker, this.resource)) : Double.compare(GoalUtils.utilizationPercentage(o.broker, this.resource), GoalUtils.utilizationPercentage(this.broker, this.resource));
        return result != 0 ? result : Integer.compare(this.broker.id(), o.broker.id());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CandidateBroker that = (CandidateBroker)o;
        int result = Double.compare(GoalUtils.utilizationPercentage(that.broker, this.resource), GoalUtils.utilizationPercentage(this.broker, this.resource));
        return result == 0 && this.broker.id() == that.broker.id();
    }

    public int hashCode() {
        return this.broker.id();
    }

    public String toString() {
        return String.format("CandidateBroker{%s util: %f, resource: %s, excluded for (leadership: %s, replica move: %s)}", new Object[]{this.broker, GoalUtils.utilizationPercentage(this.broker, this.resource), this.resource, this.excludedForLeadership, this.excludedForReplicaMove});
    }
}

