/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.TopicPartition;

@Immutable
public class DetailedProposal
implements Comparable<DetailedProposal> {
    public final TopicPartition topicPartition;
    public final int brokerForRebalance;
    public final double resourceLoad;
    public final ActionType actionType;
    public final String reason;

    public DetailedProposal(TopicPartition topicPartition, int brokerForRebalance, double resourceLoad, ActionType actionType, String reason) {
        this.topicPartition = topicPartition;
        this.brokerForRebalance = brokerForRebalance;
        this.resourceLoad = resourceLoad;
        this.actionType = actionType;
        this.reason = reason;
    }

    @Override
    public int compareTo(DetailedProposal detailedProposal) {
        return Double.compare(this.resourceLoad, detailedProposal.resourceLoad);
    }

    public Result result(boolean isAccepted) {
        return new Result(this, isAccepted);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailedProposal that = (DetailedProposal)o;
        return this.brokerForRebalance == that.brokerForRebalance && Double.compare(that.resourceLoad, this.resourceLoad) == 0 && Objects.equals(this.topicPartition, that.topicPartition) && this.actionType == that.actionType && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topicPartition, this.brokerForRebalance, this.resourceLoad, this.actionType, this.reason});
    }

    public static Builder builder(TopicPartition topicPartition, int brokerForRebalance, double resourceLoad, ActionType actionType) {
        return new Builder(topicPartition, brokerForRebalance, resourceLoad, actionType);
    }

    public static interface DetailedReasonBuilder {
        public String build(String var1);
    }

    public static class Builder {
        private final TopicPartition topicPartition;
        private final int brokerForRebalance;
        private final double resourceLoad;
        private final ActionType actionType;

        private Builder(TopicPartition topicPartition, int brokerForRebalance, double resourceLoad, ActionType actionType) {
            this.topicPartition = topicPartition;
            this.brokerForRebalance = brokerForRebalance;
            this.resourceLoad = resourceLoad;
            this.actionType = actionType;
        }

        public DetailedProposal build(String reason) {
            return new DetailedProposal(this.topicPartition, this.brokerForRebalance, this.resourceLoad, this.actionType, reason);
        }
    }

    @Immutable
    public static class Result
    implements Comparable<Result> {
        public final DetailedProposal proposal;
        public final boolean isAccepted;

        public Result(DetailedProposal detailedProposal, boolean isAccepted) {
            this.proposal = detailedProposal;
            this.isAccepted = isAccepted;
        }

        @Override
        public int compareTo(Result detailedProposalResult) {
            return this.proposal.compareTo(detailedProposalResult.proposal);
        }

        public String toString() {
            String acceptedStr = this.isAccepted ? "ACCEPTED" : "REJECTED";
            return String.format("%s %s balancing broker %d (partition %s) (reason: %s)", acceptedStr, this.proposal.actionType.name(), this.proposal.brokerForRebalance, this.proposal.topicPartition, this.proposal.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.isAccepted == result.isAccepted && Objects.equals(this.proposal, result.proposal);
        }

        public int hashCode() {
            return Objects.hash(this.proposal, this.isAccepted);
        }
    }
}

