/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IncrementalResourceDistributionStatsSnapshot {
    private final int numBrokersAboveLowerBoundThreshold;
    private final double incrementalLowerBoundPercentage;
    private final double incrementalStepRatioPercentage;
    private final double meanUtilizationPercentage;
    private final Map<Integer, Double> desiredIncrementalImprovementByBrokerId;

    public IncrementalResourceDistributionStatsSnapshot(Map<Integer, Double> desiredIncrementalImprovementPercentageByBrokerId, double incrementalLowerBoundPercentage, double incrementalStepRatioPercentage, double meanUtilizationPercentage) {
        this.desiredIncrementalImprovementByBrokerId = desiredIncrementalImprovementPercentageByBrokerId;
        this.incrementalLowerBoundPercentage = incrementalLowerBoundPercentage;
        this.incrementalStepRatioPercentage = incrementalStepRatioPercentage;
        this.meanUtilizationPercentage = meanUtilizationPercentage;
        this.numBrokersAboveLowerBoundThreshold = (int)desiredIncrementalImprovementPercentageByBrokerId.values().stream().filter(t -> AnalyzerUtils.isLarger(t, incrementalLowerBoundPercentage)).count();
    }

    public int numBrokersAboveLowerBoundThreshold() {
        return this.numBrokersAboveLowerBoundThreshold;
    }

    public double meanUtilizationPercentage() {
        return this.meanUtilizationPercentage;
    }

    public double incrementalStepRatio() {
        return this.incrementalStepRatioPercentage;
    }

    public double desiredIncrementalImprovementPercent(int brokerId) {
        return Math.max(this.desiredIncrementalImprovementByBrokerId.get(brokerId), this.incrementalLowerBoundPercentage);
    }

    public String toString() {
        return "IncrementalResourceDistributionStatsSnapshot{numBrokersAboveLowerBoundThreshold=" + this.numBrokersAboveLowerBoundThreshold + ", incrementalLowerBound=" + this.incrementalLowerBoundPercentage + ", incrementalStepRatio=" + this.incrementalStepRatioPercentage + ", meanUtilizationPercentage=" + this.meanUtilizationPercentage + ", incrementalBalancingThresholdByBrokerId=" + this.desiredIncrementalImprovementByBrokerId + '}';
    }
}

