/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.internals;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.DistributionThresholdUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.AbstractDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerResourceStats;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

public class ResourceDistributionStatsSnapshot
extends AbstractDistributionStatsSnapshot {
    private final int numBrokersUnderLowUtilizationThreshold;
    private final ResourceValueThresholds resourceValueThresholds;

    private ResourceDistributionStatsSnapshot(BrokerResourceStats minBrokerResource, BrokerResourceStats maxBrokerResource, int numBrokersUnderLowUtilizationThreshold, ResourceValueThresholds resourceValueThresholds) {
        super(minBrokerResource, maxBrokerResource);
        this.numBrokersUnderLowUtilizationThreshold = numBrokersUnderLowUtilizationThreshold;
        this.resourceValueThresholds = resourceValueThresholds;
    }

    public int numBrokersUnderLowUtilizationThreshold() {
        return this.numBrokersUnderLowUtilizationThreshold;
    }

    public ResourceValueThresholds resourceValueThresholds() {
        return this.resourceValueThresholds;
    }

    public String toString() {
        return "ResourceDistributionStatsSnapshot{minBrokerResourceUnderLowerLimitOpt=" + this.minBrokerResource + ", maxBrokerResourceOverUpperLimitOpt=" + this.maxBrokerResource + ", numBrokersUnderLowUtilizationThreshold=" + this.numBrokersUnderLowUtilizationThreshold + ", resourceValueThresholds=" + this.resourceValueThresholds + "}";
    }

    public static Optional<ResourceDistributionStatsSnapshot> tryCompute(DistributionThresholdUtils.ResourcePercentageThresholds percentageThresholds, Collection<BrokerResourceStats> resources) throws IllegalArgumentException {
        if (resources.isEmpty()) {
            String errorMsg = "No broker resources were given to compute.";
            LOG.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        Optional<Double> brokerCapacityOpt = ResourceDistributionStatsSnapshot.validateEvenBrokerResourceCapacities(resources, percentageThresholds.resource());
        if (!brokerCapacityOpt.isPresent()) {
            LOG.warn("Could not compute resource distribution stats snapshot due to uneven broker capacities.");
            return Optional.empty();
        }
        double brokerCapacity = brokerCapacityOpt.get();
        double lowerBalanceValue = percentageThresholds.balanceLowerPercent() * brokerCapacity;
        double upperBalanceValue = percentageThresholds.balanceUpperPercent() * brokerCapacity;
        double lowUtilizationValue = percentageThresholds.lowUtilizationPercent() * brokerCapacity;
        double meanUtilizationValue = percentageThresholds.meanUtilizationPercent() * brokerCapacity;
        int numBrokerUnderMinUtil = 0;
        BrokerResourceStats minBrokerResourceUnderLowerLimit = null;
        BrokerResourceStats maxBrokerResourceOverUpperLimit = null;
        for (BrokerResourceStats brokerResource : resources) {
            if (brokerResource.utilizationValue < lowUtilizationValue) {
                ++numBrokerUnderMinUtil;
                continue;
            }
            minBrokerResourceUnderLowerLimit = ResourceDistributionStatsSnapshot.minResource(brokerResource, minBrokerResourceUnderLowerLimit);
            maxBrokerResourceOverUpperLimit = ResourceDistributionStatsSnapshot.maxResource(brokerResource, maxBrokerResourceOverUpperLimit);
        }
        return Optional.of(new ResourceDistributionStatsSnapshot(minBrokerResourceUnderLowerLimit, maxBrokerResourceOverUpperLimit, numBrokerUnderMinUtil, new ResourceValueThresholds(upperBalanceValue, lowerBalanceValue, lowUtilizationValue, meanUtilizationValue, percentageThresholds.resource())));
    }

    private static Optional<Double> validateEvenBrokerResourceCapacities(Collection<BrokerResourceStats> resources, Resource resource) {
        return GoalUtils.validateEvenBrokerResourceCapacities(resources.stream().collect(Collectors.toMap(k -> k.brokerId, v -> v.capacityValue)), resource);
    }

    @ThreadSafe
    public static class ResourceValueThresholds {
        public final double balanceUpperValueThreshold;
        public final double balanceLowerValueThreshold;
        public final double lowUtilizationValueThreshold;
        public final double meanUtilizationValueThreshold;
        public final Resource resource;

        public ResourceValueThresholds(double balanceUpperValueThreshold, double balanceLowerValueThreshold, double lowUtilizationValueThreshold, double meanUtilizationValueThreshold, Resource resource) {
            this.balanceUpperValueThreshold = balanceUpperValueThreshold;
            this.balanceLowerValueThreshold = balanceLowerValueThreshold;
            this.lowUtilizationValueThreshold = lowUtilizationValueThreshold;
            this.meanUtilizationValueThreshold = meanUtilizationValueThreshold;
            this.resource = resource;
        }

        public String toString() {
            String lowUtilStr = String.format("%.2f", this.lowUtilizationValueThreshold);
            String meanUtilStr = String.format("%.2f", this.meanUtilizationValueThreshold);
            String balanceLowerThresholdStr = String.format("%.2f", this.balanceLowerValueThreshold);
            String balanceUpperThresholdStr = String.format("%.2f", this.balanceUpperValueThreshold);
            return String.format("Resource Value Thresholds for %s - low utilization threshold %s, mean utilization threshold %s, lower limit: %s, upper limit: %s", this.resource.resource(), lowUtilStr, meanUtilStr, balanceLowerThresholdStr, balanceUpperThresholdStr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceValueThresholds that = (ResourceValueThresholds)o;
            return Double.compare(that.balanceUpperValueThreshold, this.balanceUpperValueThreshold) == 0 && Double.compare(that.balanceLowerValueThreshold, this.balanceLowerValueThreshold) == 0 && Double.compare(that.lowUtilizationValueThreshold, this.lowUtilizationValueThreshold) == 0 && Double.compare(that.meanUtilizationValueThreshold, this.meanUtilizationValueThreshold) == 0 && this.resource == that.resource;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.balanceUpperValueThreshold, this.balanceLowerValueThreshold, this.lowUtilizationValueThreshold, this.meanUtilizationValueThreshold, this.resource});
        }
    }
}

