/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerResourceStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.BrokerResourceMetric;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class BaseDistributionGoalMetrics {
    protected static final String MIN_RESOURCE_METRIC_NAME = "min-broker-resource";
    protected static final String MAX_RESOURCE_METRIC_NAME = "max-broker-resource";
    static final String LOWER_BALANCE_THRESHOLD_METRIC_NAME = "lower-balance-threshold";
    static final String UPPER_BALANCE_THRESHOLD_METRIC_NAME = "upper-balance-threshold";
    public static final String GOAL_TAG = "goal";
    protected SortedMap<String, String> tags = new TreeMap<String, String>();
    protected final String goalName;
    protected final BrokerResourceMetric maxBrokerResource;
    protected final BrokerResourceMetric minBrokerResource;
    protected volatile double lowerBalanceThresholdValue;
    protected volatile double upperBalanceThresholdValue;
    protected final DataBalancerMetricsRegistry metricsRegistry;

    public BaseDistributionGoalMetrics(String goalName, DataBalancerMetricsRegistry metricsRegistry, Class<?> metricClass) {
        this(new BrokerResourceMetric.Builder(MAX_RESOURCE_METRIC_NAME, goalName, metricsRegistry, metricClass), new BrokerResourceMetric.Builder(MIN_RESOURCE_METRIC_NAME, goalName, metricsRegistry, metricClass), goalName, metricsRegistry, metricClass);
    }

    BaseDistributionGoalMetrics(BrokerResourceMetric.Builder maxBrokerResourceBuilder, BrokerResourceMetric.Builder minBrokerResourceBuilder, String goalName, DataBalancerMetricsRegistry metricsRegistry, Class<?> metricClass) {
        this.tags.put(GOAL_TAG, goalName);
        this.maxBrokerResource = maxBrokerResourceBuilder.build(new TreeMap<String, String>(this.tags));
        this.minBrokerResource = minBrokerResourceBuilder.build(new TreeMap<String, String>(this.tags));
        this.goalName = goalName;
        this.metricsRegistry = metricsRegistry;
        this.registerMetrics(metricClass);
    }

    protected synchronized void update(BrokerResourceStats maxBrokerResourceOverUpperLimitOpt, BrokerResourceStats minBrokerResourceUnderLowerLimitOpt, double balanceLowerValueThreshold, double balanceUpperValueThreshold) {
        this.maxBrokerResource.updateResource(maxBrokerResourceOverUpperLimitOpt);
        this.minBrokerResource.updateResource(minBrokerResourceUnderLowerLimitOpt);
        this.lowerBalanceThresholdValue = balanceLowerValueThreshold;
        this.upperBalanceThresholdValue = balanceUpperValueThreshold;
    }

    protected void registerMetrics(Class<?> metricClass) {
        this.metricsRegistry.newGauge(metricClass, LOWER_BALANCE_THRESHOLD_METRIC_NAME, () -> this.lowerBalanceThresholdValue, new TreeMap<String, String>(this.tags));
        this.metricsRegistry.newGauge(metricClass, UPPER_BALANCE_THRESHOLD_METRIC_NAME, () -> this.upperBalanceThresholdValue, new TreeMap<String, String>(this.tags));
    }
}

